/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring.autodeployment;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.flowable.form.spring.autodeployment.AutoDeploymentStrategy;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;

public abstract class AbstractAutoDeploymentStrategy
implements AutoDeploymentStrategy {
    protected abstract String getDeploymentMode();

    @Override
    public boolean handlesMode(String mode) {
        return StringUtils.equalsIgnoreCase((CharSequence)mode, (CharSequence)this.getDeploymentMode());
    }

    protected String determineResourceName(Resource resource) {
        String resourceName = null;
        if (resource instanceof ContextResource) {
            resourceName = ((ContextResource)resource).getPathWithinContext();
        } else if (resource instanceof ByteArrayResource) {
            resourceName = resource.getDescription();
        } else {
            try {
                resourceName = resource.getFile().getAbsolutePath();
            }
            catch (IOException e) {
                resourceName = resource.getFilename();
            }
        }
        return resourceName;
    }
}

