/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.rest.service.api.form;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import org.flowable.form.api.FormInstance;
import org.flowable.form.api.FormService;
import org.flowable.form.rest.FormRestResponseFactory;
import org.flowable.form.rest.service.api.form.FormInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Form Instances"}, description="Manage Form Instances", authorizations={@Authorization(value="basicAuth")})
public class FormInstanceResource {
    @Autowired
    protected FormService formService;
    @Autowired
    protected FormRestResponseFactory formRestResponseFactory;

    @ApiOperation(value="Get a form instance", tags={"Form Instances"}, nickname="getFormInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the form instance was found and returned."), @ApiResponse(code=404, message="Indicates the requested form instance was not found.")})
    @GetMapping(value={"/form/form-instance/{formInstanceId}"}, produces={"application/json"})
    public FormInstanceResponse getFormInstance(@ApiParam(name="formInstanceId") @PathVariable String formInstanceId, HttpServletRequest request) {
        return this.formRestResponseFactory.createFormInstanceResponse((FormInstance)this.formService.createFormInstanceQuery().id(formInstanceId).singleResult());
    }
}

