/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.deployer;

import java.util.Map;
import org.flowable.engine.impl.persistence.deploy.Deployer;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.api.FormRepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDeployer
implements Deployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDeployer.class);

    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        if (!deployment.isNew()) {
            return;
        }
        LOGGER.debug("FormDeployer: processing deployment {}", (Object)deployment.getName());
        FormDeploymentBuilder formDeploymentBuilder = null;
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!resourceName.endsWith(".form")) continue;
            LOGGER.info("FormDeployer: processing resource {}", (Object)resourceName);
            if (formDeploymentBuilder == null) {
                FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService();
                formDeploymentBuilder = formRepositoryService.createDeployment();
            }
            formDeploymentBuilder.addFormBytes(resourceName, ((ResourceEntity)resources.get(resourceName)).getBytes());
        }
        if (formDeploymentBuilder != null) {
            formDeploymentBuilder.parentDeploymentId(deployment.getId());
            if (deployment.getTenantId() != null && deployment.getTenantId().length() > 0) {
                formDeploymentBuilder.tenantId(deployment.getTenantId());
            }
            formDeploymentBuilder.deploy();
        }
    }
}

