/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.configurator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.flowable.engine.cfg.AbstractEngineConfigurator;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.db.CustomMyBatisTypeHandlerConfig;
import org.flowable.engine.common.impl.db.CustomMybatisTypeAliasConfig;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.Deployer;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.deployer.FormDeployer;
import org.flowable.form.engine.impl.cfg.StandaloneFormEngineConfiguration;
import org.flowable.form.engine.impl.db.EntityDependencyOrder;
import org.flowable.form.engine.impl.persistence.ResourceRefTypeHandler;
import org.flowable.form.engine.impl.persistence.entity.ResourceRef;

public class FormEngineConfigurator
extends AbstractEngineConfigurator {
    protected FormEngineConfiguration formEngineConfiguration;

    public int getPriority() {
        return 300000;
    }

    protected List<Deployer> getCustomDeployers() {
        ArrayList<Deployer> deployers = new ArrayList<Deployer>();
        deployers.add(new FormDeployer());
        return deployers;
    }

    protected String getMybatisCfgPath() {
        return "org/flowable/form/db/mapping/mappings.xml";
    }

    protected List<CustomMybatisTypeAliasConfig> getMybatisTypeAliases() {
        return Collections.singletonList(new CustomMybatisTypeAliasConfig("ResourceRefTypeHandler", ResourceRefTypeHandler.class));
    }

    protected List<CustomMyBatisTypeHandlerConfig> getMybatisTypeHandlers() {
        return Collections.singletonList(new CustomMyBatisTypeHandlerConfig(ResourceRef.class, JdbcType.VARCHAR, ResourceRefTypeHandler.class));
    }

    public void configure(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (this.formEngineConfiguration == null) {
            this.formEngineConfiguration = new StandaloneFormEngineConfiguration();
        }
        this.initialiseCommonProperties(processEngineConfiguration, (AbstractEngineConfiguration)this.formEngineConfiguration);
        this.initFormEngine();
        this.initServiceConfigurations(processEngineConfiguration, (AbstractEngineConfiguration)this.formEngineConfiguration);
    }

    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    protected synchronized FormEngine initFormEngine() {
        if (this.formEngineConfiguration == null) {
            throw new FlowableException("FormEngineConfiguration is required");
        }
        return this.formEngineConfiguration.buildFormEngine();
    }

    public FormEngineConfiguration getFormEngineConfiguration() {
        return this.formEngineConfiguration;
    }

    public FormEngineConfigurator setFormEngineConfiguration(FormEngineConfiguration formEngineConfiguration) {
        this.formEngineConfiguration = formEngineConfiguration;
        return this;
    }
}

