/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.persistence.deploy;

import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.persistence.deploy.DeploymentCache;
import org.flowable.form.api.FormDefinition;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormDefinitionQueryImpl;
import org.flowable.form.engine.impl.persistence.deploy.Deployer;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormResourceEntity;

public class DeploymentManager {
    protected FormEngineConfiguration engineConfig;
    protected DeploymentCache<FormDefinitionCacheEntry> formCache;
    protected List<Deployer> deployers;
    protected FormDefinitionEntityManager formDefinitionEntityManager;
    protected FormDeploymentEntityManager deploymentEntityManager;

    public DeploymentManager(DeploymentCache<FormDefinitionCacheEntry> formCache, FormEngineConfiguration engineConfig) {
        this.formCache = formCache;
        this.engineConfig = engineConfig;
    }

    public void deploy(FormDeploymentEntity deployment) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment);
        }
    }

    public FormDefinitionEntity findDeployedFormDefinitionById(String formDefinitionId) {
        FormDefinitionEntity formDefinition;
        if (formDefinitionId == null) {
            throw new FlowableException("Invalid form definition id : null");
        }
        FormDefinitionCacheEntry cacheEntry = (FormDefinitionCacheEntry)this.formCache.get(formDefinitionId);
        FormDefinitionEntity formDefinitionEntity = formDefinition = cacheEntry != null ? cacheEntry.getFormDefinitionEntity() : null;
        if (formDefinition == null) {
            formDefinition = (FormDefinitionEntity)this.engineConfig.getFormDefinitionEntityManager().findById(formDefinitionId);
            if (formDefinition == null) {
                throw new FlowableObjectNotFoundException("no deployed form definition found with id '" + formDefinitionId + "'");
            }
            formDefinition = this.resolveFormDefinition(formDefinition).getFormDefinitionEntity();
        }
        return formDefinition;
    }

    public FormDefinitionEntity findDeployedLatestFormDefinitionByKey(String formDefinitionKey) {
        FormDefinitionEntity formDefinition = this.formDefinitionEntityManager.findLatestFormDefinitionByKey(formDefinitionKey);
        if (formDefinition == null) {
            throw new FlowableObjectNotFoundException("no form definitions deployed with key '" + formDefinitionKey + "'");
        }
        formDefinition = this.resolveFormDefinition(formDefinition).getFormDefinitionEntity();
        return formDefinition;
    }

    public FormDefinitionEntity findDeployedLatestFormDefinitionByKeyAndTenantId(String formDefinitionKey, String tenantId) {
        FormDefinitionEntity formDefinition = this.formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(formDefinitionKey, tenantId);
        if (formDefinition == null) {
            throw new FlowableObjectNotFoundException("no form definitions deployed with key '" + formDefinitionKey + "' for tenant identifier '" + tenantId + "'");
        }
        formDefinition = this.resolveFormDefinition(formDefinition).getFormDefinitionEntity();
        return formDefinition;
    }

    public FormDefinitionEntity findDeployedLatestFormDefinitionByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        FormDefinitionEntity formDefinition = this.formDefinitionEntityManager.findLatestFormDefinitionByKeyAndParentDeploymentId(formDefinitionKey, parentDeploymentId);
        if (formDefinition == null) {
            throw new FlowableObjectNotFoundException("no form definitions deployed with key '" + formDefinitionKey + "' for parent deployment id '" + parentDeploymentId + "'");
        }
        formDefinition = this.resolveFormDefinition(formDefinition).getFormDefinitionEntity();
        return formDefinition;
    }

    public FormDefinitionEntity findDeployedLatestFormDefinitionByKeyParentDeploymentIdAndTenantId(String formDefinitionKey, String parentDeploymentId, String tenantId) {
        FormDefinitionEntity formDefinition = this.formDefinitionEntityManager.findLatestFormDefinitionByKeyParentDeploymentIdAndTenantId(formDefinitionKey, parentDeploymentId, tenantId);
        if (formDefinition == null) {
            throw new FlowableObjectNotFoundException("no form definitions deployed with key '" + formDefinitionKey + "' for parent deployment id '" + parentDeploymentId + "' and tenant identifier '" + tenantId + "'");
        }
        formDefinition = this.resolveFormDefinition(formDefinition).getFormDefinitionEntity();
        return formDefinition;
    }

    public FormDefinitionEntity findDeployedFormDefinitionByKeyAndVersionAndTenantId(String formDefinitionKey, int formVersion, String tenantId) {
        FormDefinitionEntity formDefinition = this.formDefinitionEntityManager.findFormDefinitionByKeyAndVersionAndTenantId(formDefinitionKey, formVersion, tenantId);
        if (formDefinition == null) {
            throw new FlowableObjectNotFoundException("no form definitions deployed with key = '" + formDefinitionKey + "' and version = '" + formVersion + "'");
        }
        formDefinition = this.resolveFormDefinition(formDefinition).getFormDefinitionEntity();
        return formDefinition;
    }

    public FormDefinitionCacheEntry resolveFormDefinition(FormDefinition formDefinition) {
        String formDefinitionId = formDefinition.getId();
        String deploymentId = formDefinition.getDeploymentId();
        FormDefinitionCacheEntry cachedForm = (FormDefinitionCacheEntry)this.formCache.get(formDefinitionId);
        if (cachedForm == null) {
            FormDeploymentEntity deployment = (FormDeploymentEntity)this.engineConfig.getDeploymentEntityManager().findById(deploymentId);
            List<FormResourceEntity> resources = this.engineConfig.getResourceEntityManager().findResourcesByDeploymentId(deploymentId);
            for (FormResourceEntity resource : resources) {
                deployment.addResource(resource);
            }
            deployment.setNew(false);
            this.deploy(deployment);
            cachedForm = (FormDefinitionCacheEntry)this.formCache.get(formDefinitionId);
            if (cachedForm == null) {
                throw new FlowableException("deployment '" + deploymentId + "' didn't put form definition '" + formDefinitionId + "' in the cache");
            }
        }
        return cachedForm;
    }

    public void removeDeployment(String deploymentId) {
        FormDeploymentEntity deployment = (FormDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.");
        }
        List forms = new FormDefinitionQueryImpl().deploymentId(deploymentId).list();
        this.deploymentEntityManager.deleteDeployment(deploymentId);
        for (FormDefinition form : forms) {
            this.formCache.remove(form.getId());
        }
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<FormDefinitionCacheEntry> getFormCache() {
        return this.formCache;
    }

    public void setFormCache(DeploymentCache<FormDefinitionCacheEntry> formCache) {
        this.formCache = formCache;
    }

    public FormDefinitionEntityManager getFormDefinitionEntityManager() {
        return this.formDefinitionEntityManager;
    }

    public void setFormDefinitionEntityManager(FormDefinitionEntityManager formDefinitionEntityManager) {
        this.formDefinitionEntityManager = formDefinitionEntityManager;
    }

    public FormDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(FormDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }
}

