/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.deployer;

import java.util.List;
import java.util.Map;
import org.flowable.form.engine.impl.parser.FormDefinitionParse;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.persistence.entity.FormResourceEntity;
import org.flowable.form.model.FormModel;

public class ParsedDeployment {
    protected FormDeploymentEntity deploymentEntity;
    protected List<FormDefinitionEntity> formDefinitions;
    protected Map<FormDefinitionEntity, FormDefinitionParse> mapFormDefinitionsToParses;
    protected Map<FormDefinitionEntity, FormResourceEntity> mapFormDefinitionsToResources;

    public ParsedDeployment(FormDeploymentEntity entity, List<FormDefinitionEntity> formDefinitions, Map<FormDefinitionEntity, FormDefinitionParse> mapFormDefinitionsToParses, Map<FormDefinitionEntity, FormResourceEntity> mapFormDefinitionsToResources) {
        this.deploymentEntity = entity;
        this.formDefinitions = formDefinitions;
        this.mapFormDefinitionsToParses = mapFormDefinitionsToParses;
        this.mapFormDefinitionsToResources = mapFormDefinitionsToResources;
    }

    public FormDeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public List<FormDefinitionEntity> getAllFormDefinitions() {
        return this.formDefinitions;
    }

    public FormResourceEntity getResourceForFormDefinition(FormDefinitionEntity formDefinition) {
        return this.mapFormDefinitionsToResources.get(formDefinition);
    }

    public FormDefinitionParse getFormDefinitionParseForFormDefinition(FormDefinitionEntity formDefinition) {
        return this.mapFormDefinitionsToParses.get(formDefinition);
    }

    public FormModel getFormModelForFormDefinition(FormDefinitionEntity formDefinition) {
        FormDefinitionParse parse = this.getFormDefinitionParseForFormDefinition(formDefinition);
        return parse == null ? null : parse.getFormModel();
    }
}

