/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.rabbit;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.model.RabbitInboundChannelModel;
import org.flowable.eventregistry.model.RabbitOutboundChannelModel;
import org.flowable.eventregistry.spring.rabbit.RabbitChannelMessageListenerAdapter;
import org.flowable.eventregistry.spring.rabbit.RabbitOperationsOutboundEventChannelAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class RabbitChannelDefinitionProcessor
implements BeanFactoryAware,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
ChannelModelProcessor {
    public static final String CHANNEL_ID_PREFIX = "org.flowable.eventregistry.rabbit.ChannelRabbitListenerEndpointContainer#";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RabbitListenerEndpointRegistry endpointRegistry;
    protected String containerFactoryBeanName = "rabbitListenerContainerFactory";
    protected RabbitOperations rabbitOperations;
    protected RabbitListenerContainerFactory<?> containerFactory;
    protected BeanFactory beanFactory;
    protected ApplicationContext applicationContext;
    protected boolean contextRefreshed;
    protected BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    protected StringValueResolver embeddedValueResolver;
    protected BeanExpressionContext expressionContext;

    public boolean canProcess(ChannelModel channelModel) {
        return channelModel instanceof RabbitInboundChannelModel || channelModel instanceof RabbitOutboundChannelModel;
    }

    public void registerChannelModel(ChannelModel channelModel, String tenantId, EventRegistry eventRegistry, EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        if (channelModel instanceof RabbitInboundChannelModel) {
            RabbitInboundChannelModel rabbitChannelDefinition = (RabbitInboundChannelModel)channelModel;
            this.logger.info("Starting to register inbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
            RabbitListenerEndpoint endpoint = this.createRabbitListenerEndpoint(rabbitChannelDefinition, tenantId, eventRegistry);
            this.registerEndpoint(endpoint, null);
            this.logger.info("Finished registering inbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
        } else if (channelModel instanceof RabbitOutboundChannelModel) {
            this.logger.info("Starting to register outbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
            this.processOutboundDefinition((RabbitOutboundChannelModel)channelModel);
            this.logger.info("Finished registering outbound channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
        }
    }

    protected RabbitListenerEndpoint createRabbitListenerEndpoint(RabbitInboundChannelModel channelModel, String tenantId, EventRegistry eventRegistry) {
        String endpointId = this.getEndpointId((ChannelModel)channelModel, tenantId);
        SimpleRabbitListenerEndpoint endpoint = new SimpleRabbitListenerEndpoint();
        endpoint.setId(endpointId);
        endpoint.setQueueNames(this.resolveQueues(channelModel));
        endpoint.setConcurrency(this.resolveExpressionAsStringOrInteger(channelModel.getConcurrency(), "concurrency"));
        endpoint.setBeanFactory(this.beanFactory);
        endpoint.setExclusive(channelModel.isExclusive());
        endpoint.setPriority(this.resolvePriority(channelModel));
        endpoint.setAdmin((AmqpAdmin)this.resolveAdmin(channelModel));
        endpoint.setTaskExecutor(this.resolveExecutor(channelModel));
        endpoint.setAckMode(this.resolveAckMode(channelModel));
        endpoint.setMessageListener(this.createMessageListener(eventRegistry, (InboundChannelModel)channelModel));
        return endpoint;
    }

    protected void processOutboundDefinition(RabbitOutboundChannelModel channelDefinition) {
        String routingKey = channelDefinition.getRoutingKey();
        if (channelDefinition.getOutboundEventChannelAdapter() == null && StringUtils.hasText((String)routingKey)) {
            String resolvedRoutingKey = this.resolve(routingKey);
            String exchange = this.resolve(channelDefinition.getExchange());
            channelDefinition.setOutboundEventChannelAdapter((Object)new RabbitOperationsOutboundEventChannelAdapter(this.rabbitOperations, exchange, resolvedRoutingKey));
        }
    }

    protected String resolveExpressionAsStringOrInteger(String value, String attribute) {
        if (!StringUtils.hasLength((String)value)) {
            return null;
        }
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        if (resolved instanceof Integer) {
            return resolved.toString();
        }
        throw new IllegalStateException("The [" + attribute + "] must resolve to a String. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
    }

    protected String[] resolveQueues(RabbitInboundChannelModel channelDefinition) {
        Collection queues = channelDefinition.getQueues();
        if (queues == null) {
            throw new IllegalArgumentException("Queues in " + channelDefinition + " must not be null");
        }
        ArrayList<String> resultQueues = new ArrayList<String>();
        for (String queue : queues) {
            this.resolveQueues(this.resolveExpression(queue), resultQueues, channelDefinition);
        }
        return resultQueues.toArray(new String[0]);
    }

    protected void resolveQueues(Object resolvedValue, List<String> result, RabbitInboundChannelModel channelDefinition) {
        List<String> resolvedValueToUse = resolvedValue;
        if (resolvedValueToUse instanceof String[]) {
            resolvedValueToUse = Arrays.asList((String[])resolvedValueToUse);
        }
        if (resolvedValueToUse instanceof String) {
            result.add((String)((Object)resolvedValueToUse));
        } else if (resolvedValueToUse instanceof Queue) {
            result.add(((Queue)resolvedValueToUse).getName());
        } else if (resolvedValueToUse instanceof Iterable) {
            for (Object object : (Iterable)resolvedValueToUse) {
                this.resolveQueues(object, result, channelDefinition);
            }
        } else {
            throw new IllegalArgumentException("Channel definition " + channelDefinition + " cannot resolve " + resolvedValue + " as a String[] or a String or a Queue");
        }
    }

    protected Integer resolvePriority(RabbitInboundChannelModel channelDefinition) {
        String priority = this.resolve(channelDefinition.getPriority());
        if (StringUtils.hasText((String)priority)) {
            try {
                return Integer.valueOf(priority);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid priority value for " + channelDefinition + " (must be an integer)", ex);
            }
        }
        return null;
    }

    protected RabbitAdmin resolveAdmin(RabbitInboundChannelModel channelDefinition) {
        String rabbitAdmin = this.resolve(channelDefinition.getAdmin());
        if (StringUtils.hasText((String)rabbitAdmin)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to resolve RabbitAdmin by bean name");
            try {
                return (RabbitAdmin)this.beanFactory.getBean(rabbitAdmin, RabbitAdmin.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new IllegalArgumentException("Could not register rabbit listener endpoint on [" + channelDefinition + "], no " + RabbitAdmin.class.getSimpleName() + " with id '" + rabbitAdmin + "' was found in the application context", ex);
            }
        }
        return null;
    }

    protected AcknowledgeMode resolveAckMode(RabbitInboundChannelModel channelDefinition) {
        String ackModeAttr = channelDefinition.getAckMode();
        if (StringUtils.hasText((String)ackModeAttr)) {
            Object ackMode = this.resolveExpression(ackModeAttr);
            if (ackMode instanceof String) {
                return AcknowledgeMode.valueOf((String)((String)ackMode));
            }
            if (ackMode instanceof AcknowledgeMode) {
                return (AcknowledgeMode)ackMode;
            }
            throw new IllegalArgumentException("ackMode in definition [ " + channelDefinition + " ] must resolve to a String or AcknowledgeMode");
        }
        return null;
    }

    protected TaskExecutor resolveExecutor(RabbitInboundChannelModel channelDefinition) {
        String executorBeanName = this.resolve(channelDefinition.getExecutor());
        if (StringUtils.hasText((String)executorBeanName)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to resolve TaskExecutor by bean name");
            try {
                return (TaskExecutor)this.beanFactory.getBean(executorBeanName, TaskExecutor.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new IllegalArgumentException("Could not register rabbit listener endpoint on [" + channelDefinition + "], no " + TaskExecutor.class.getSimpleName() + " with id '" + executorBeanName + "' was found in the application context", ex);
            }
        }
        return null;
    }

    protected Object resolveExpression(String value) {
        String resolvedValue = this.resolve(value);
        return this.resolver.evaluate(resolvedValue, this.expressionContext);
    }

    protected MessageListener createMessageListener(EventRegistry eventRegistry, InboundChannelModel inboundChannelModel) {
        return new RabbitChannelMessageListenerAdapter(eventRegistry, inboundChannelModel);
    }

    public void unregisterChannelModel(ChannelModel channelModel, String tenantId, EventRepositoryService eventRepositoryService) {
        Field listenerContainersField;
        this.logger.info("Starting to unregister channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
        String endpointId = this.getEndpointId(channelModel, tenantId);
        MessageListenerContainer listenerContainer = this.endpointRegistry.getListenerContainer(endpointId);
        if (listenerContainer != null) {
            this.logger.debug("Stopping message listener {} for channel {} in tenant {}", new Object[]{listenerContainer, channelModel.getKey(), tenantId});
            listenerContainer.stop();
        }
        if (listenerContainer instanceof DisposableBean) {
            try {
                this.logger.debug("Destroying message listener {} for channel {} in tenant {}", new Object[]{listenerContainer, channelModel.getKey(), tenantId});
                ((DisposableBean)listenerContainer).destroy();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to destroy listener container", e);
            }
        }
        if ((listenerContainersField = ReflectionUtils.findField(this.endpointRegistry.getClass(), (String)"listenerContainers")) != null) {
            listenerContainersField.setAccessible(true);
            Map listenerContainers = (Map)ReflectionUtils.getField((Field)listenerContainersField, (Object)this.endpointRegistry);
            if (listenerContainers != null) {
                listenerContainers.remove(endpointId);
            }
        } else {
            throw new IllegalStateException("Endpoint registry " + this.endpointRegistry + " does not have listenerContainers field");
        }
        this.logger.info("Finished unregistering channel {} in tenant {}", (Object)channelModel.getKey(), (Object)tenantId);
    }

    protected void registerEndpoint(RabbitListenerEndpoint endpoint, RabbitListenerContainerFactory<?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.hasText((String)endpoint.getId(), (String)"Endpoint id must be set");
        Assert.state((this.endpointRegistry != null ? 1 : 0) != 0, (String)"No RabbitListenerEndpointRegistry set");
        boolean startImmediately = this.contextRefreshed || this.endpointRegistry.isRunning();
        this.logger.info("Registering endpoint {} with start immediately {}", (Object)endpoint, (Object)startImmediately);
        this.endpointRegistry.registerListenerContainer(endpoint, this.resolveContainerFactory(endpoint, factory), startImmediately);
        this.logger.info("Finished registering endpoint {}", (Object)endpoint);
    }

    protected RabbitListenerContainerFactory<?> resolveContainerFactory(RabbitListenerEndpoint endpoint, RabbitListenerContainerFactory<?> containerFactory) {
        if (containerFactory != null) {
            return containerFactory;
        }
        if (this.containerFactory != null) {
            return this.containerFactory;
        }
        if (this.containerFactoryBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            this.containerFactory = (RabbitListenerContainerFactory)this.beanFactory.getBean(this.containerFactoryBeanName, RabbitListenerContainerFactory.class);
            return this.containerFactory;
        }
        throw new IllegalStateException("Could not resolve the " + RabbitListenerContainerFactory.class.getSimpleName() + " to use for [" + endpoint + "] no factory was given and no default is set.");
    }

    protected String getEndpointId(ChannelModel channelModel, String tenantId) {
        String channelDefinitionKey = channelModel.getKey();
        if (!StringUtils.hasText((String)tenantId)) {
            return CHANNEL_ID_PREFIX + channelDefinitionKey;
        }
        return CHANNEL_ID_PREFIX + tenantId + "#" + channelDefinitionKey;
    }

    protected String resolve(String value) {
        if (value == null) {
            return null;
        }
        if (this.embeddedValueResolver != null) {
            return this.embeddedValueResolver.resolveStringValue(value);
        }
        return value;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            this.contextRefreshed = true;
        }
    }

    public RabbitOperations getRabbitOperations() {
        return this.rabbitOperations;
    }

    public void setRabbitOperations(RabbitOperations rabbitOperations) {
        this.rabbitOperations = rabbitOperations;
    }

    public RabbitListenerEndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setEndpointRegistry(RabbitListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public String getContainerFactoryBeanName() {
        return this.containerFactoryBeanName;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public RabbitListenerContainerFactory<?> getContainerFactory() {
        return this.containerFactory;
    }

    public void setContainerFactory(RabbitListenerContainerFactory<?> containerFactory) {
        this.containerFactory = containerFactory;
    }
}

