/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.management;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionExecutor;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionManager;
import org.flowable.eventregistry.impl.management.EventRegistryChangeDetectionRunnable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class DefaultSpringEventRegistryChangeDetectionExecutor
implements EventRegistryChangeDetectionExecutor,
DisposableBean {
    protected long initialDelayInMs;
    protected long delayInMs;
    protected TaskScheduler taskScheduler;
    protected ThreadPoolTaskScheduler threadPoolTaskScheduler;
    protected EventRegistryChangeDetectionManager eventRegistryChangeDetectionManager;

    public DefaultSpringEventRegistryChangeDetectionExecutor(long initialDelayInMs, long delayInMs) {
        this(initialDelayInMs, delayInMs, null);
    }

    public DefaultSpringEventRegistryChangeDetectionExecutor(long initialDelayInMs, long delayInMs, TaskScheduler taskScheduler) {
        this.initialDelayInMs = initialDelayInMs;
        this.delayInMs = delayInMs;
        if (taskScheduler != null) {
            this.taskScheduler = taskScheduler;
        } else {
            this.createDefaultTaskScheduler();
        }
    }

    protected void createDefaultTaskScheduler() {
        this.threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        this.threadPoolTaskScheduler.setPoolSize(1);
        this.threadPoolTaskScheduler.setThreadNamePrefix("flowable-event-change-detector-");
        this.taskScheduler = this.threadPoolTaskScheduler;
    }

    public void initialize() {
        if (this.threadPoolTaskScheduler != null) {
            this.threadPoolTaskScheduler.initialize();
        }
        Instant initialInstant = Instant.now().plus(this.initialDelayInMs, ChronoUnit.MILLIS);
        this.taskScheduler.scheduleWithFixedDelay(this.createChangeDetectionRunnable(), Date.from(initialInstant), this.delayInMs);
    }

    protected Runnable createChangeDetectionRunnable() {
        return new EventRegistryChangeDetectionRunnable(this.eventRegistryChangeDetectionManager);
    }

    public void destroy() throws Exception {
        if (this.threadPoolTaskScheduler != null) {
            this.threadPoolTaskScheduler.destroy();
        }
    }

    public EventRegistryChangeDetectionManager getEventRegistryChangeDetectionManager() {
        return this.eventRegistryChangeDetectionManager;
    }

    public void setEventRegistryChangeDetectionManager(EventRegistryChangeDetectionManager eventRegistryChangeDetectionManager) {
        this.eventRegistryChangeDetectionManager = eventRegistryChangeDetectionManager;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }
}

