/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import org.flowable.eventregistry.json.converter.FlowableEventJsonException;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;

public class EventJsonConverter {
    protected ObjectMapper objectMapper = new ObjectMapper();

    public EventModel convertToEventModel(String modelJson) {
        try {
            JsonNode correlationParameters;
            JsonNode modelNode = this.objectMapper.readTree(modelJson);
            EventModel eventModel = new EventModel();
            eventModel.setKey(modelNode.path("key").asText(null));
            eventModel.setName(modelNode.path("name").asText(null));
            JsonNode payloadNode = modelNode.path("payload");
            if (payloadNode.isArray()) {
                for (JsonNode node : payloadNode) {
                    String name = node.path("name").asText(null);
                    String type = node.path("type").asText(null);
                    boolean correlationParameter = node.path("correlationParameter").asBoolean(false);
                    if (correlationParameter) {
                        eventModel.addCorrelation(name, type);
                        continue;
                    }
                    eventModel.addPayload(name, type);
                }
            }
            if ((correlationParameters = modelNode.path("correlationParameters")).isArray()) {
                for (JsonNode correlationPayloadNode : correlationParameters) {
                    String name = correlationPayloadNode.path("name").asText(null);
                    String type = correlationPayloadNode.path("type").asText(null);
                    eventModel.addCorrelation(name, type);
                }
            }
            return eventModel;
        }
        catch (Exception e) {
            throw new FlowableEventJsonException("Error reading event json", e);
        }
    }

    public String convertToJson(EventModel definition) {
        Collection payload;
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        if (definition.getKey() != null) {
            modelNode.put("key", definition.getKey());
        }
        if (definition.getName() != null) {
            modelNode.put("name", definition.getName());
        }
        if (!(payload = definition.getPayload()).isEmpty()) {
            ArrayNode payloadNode = modelNode.putArray("payload");
            for (EventPayload eventPayload : payload) {
                ObjectNode eventPayloadNode = payloadNode.addObject();
                if (eventPayload.getName() != null) {
                    eventPayloadNode.put("name", eventPayload.getName());
                }
                if (eventPayload.getType() != null) {
                    eventPayloadNode.put("type", eventPayload.getType());
                }
                if (!eventPayload.isCorrelationParameter()) continue;
                eventPayloadNode.put("correlationParameter", true);
            }
        }
        try {
            return this.objectMapper.writeValueAsString((Object)modelNode);
        }
        catch (Exception e) {
            throw new FlowableEventJsonException("Error writing event json", e);
        }
    }
}

