/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.eventregistry.api.OutboundEventSerializer;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;

public class EventPayloadToJsonStringSerializer
implements OutboundEventSerializer {
    protected ObjectMapper objectMapper = new ObjectMapper();

    public String serialize(EventInstance eventInstance) {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        Collection payloadInstances = eventInstance.getPayloadInstances();
        for (EventPayloadInstance payloadInstance : payloadInstances) {
            String definitionType = payloadInstance.getDefinitionType();
            if ("string".equals(definitionType)) {
                objectNode.put(payloadInstance.getDefinitionName(), (String)payloadInstance.getValue());
                continue;
            }
            if ("double".equals(definitionType)) {
                objectNode.put(payloadInstance.getDefinitionName(), (Double)payloadInstance.getValue());
                continue;
            }
            if ("integer".equals(definitionType)) {
                objectNode.put(payloadInstance.getDefinitionName(), (Integer)payloadInstance.getValue());
                continue;
            }
            if ("boolean".equals(definitionType)) {
                objectNode.put(payloadInstance.getDefinitionName(), (Boolean)payloadInstance.getValue());
                continue;
            }
            throw new FlowableIllegalArgumentException("Unsupported event payload instance type: " + definitionType);
        }
        try {
            return this.objectMapper.writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            throw new FlowableException("Could not serialize event to json string", (Throwable)e);
        }
    }
}

