/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.keydetector;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.InboundEventKeyDetector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XpathBasedInboundEventKeyDetector
implements InboundEventKeyDetector<Document> {
    protected String xpathExpression;

    public XpathBasedInboundEventKeyDetector(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public String detectEventDefinitionKey(Document document) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node result = (Node)xPath.compile(this.xpathExpression).evaluate(document, XPathConstants.NODESET);
            return result.getTextContent();
        }
        catch (Exception e) {
            throw new FlowableException("Could not evaluate xpath expression ", (Throwable)e);
        }
    }
}

