/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.HasExpressionManagerEngineConfiguration;
import org.flowable.common.engine.impl.cfg.BeansConfigurationHelper;
import org.flowable.common.engine.impl.db.DbSqlSessionFactory;
import org.flowable.common.engine.impl.el.DefaultExpressionManager;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.engine.impl.interceptor.SessionFactory;
import org.flowable.common.engine.impl.persistence.deploy.DefaultDeploymentCache;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.common.engine.impl.persistence.deploy.FullDeploymentCache;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventManagementService;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRegistryConfigurationApi;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.InboundEventProcessor;
import org.flowable.eventregistry.api.OutboundEventProcessor;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionExecutor;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionManager;
import org.flowable.eventregistry.impl.DefaultEventRegistry;
import org.flowable.eventregistry.impl.DefaultInboundEventProcessor;
import org.flowable.eventregistry.impl.DefaultOutboundEventProcessor;
import org.flowable.eventregistry.impl.EventManagementServiceImpl;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineImpl;
import org.flowable.eventregistry.impl.EventRepositoryServiceImpl;
import org.flowable.eventregistry.impl.cfg.StandaloneEventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.cfg.StandaloneInMemEventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.cmd.SchemaOperationsEventRegistryEngineBuild;
import org.flowable.eventregistry.impl.db.EntityDependencyOrder;
import org.flowable.eventregistry.impl.db.EventDbSchemaManager;
import org.flowable.eventregistry.impl.deployer.CachingAndArtifactsManager;
import org.flowable.eventregistry.impl.deployer.ChannelDefinitionDeploymentHelper;
import org.flowable.eventregistry.impl.deployer.EventDefinitionDeployer;
import org.flowable.eventregistry.impl.deployer.EventDefinitionDeploymentHelper;
import org.flowable.eventregistry.impl.deployer.ParsedDeploymentBuilderFactory;
import org.flowable.eventregistry.impl.management.DefaultEventRegistryChangeDetectionExecutor;
import org.flowable.eventregistry.impl.management.DefaultEventRegistryChangeDetectionManager;
import org.flowable.eventregistry.impl.parser.ChannelDefinitionParseFactory;
import org.flowable.eventregistry.impl.parser.EventDefinitionParseFactory;
import org.flowable.eventregistry.impl.persistence.deploy.ChannelDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.deploy.Deployer;
import org.flowable.eventregistry.impl.persistence.deploy.EventDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.deploy.EventDeploymentManager;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityManagerImpl;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntityManagerImpl;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntityManagerImpl;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntityManagerImpl;
import org.flowable.eventregistry.impl.persistence.entity.data.ChannelDefinitionDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.EventDefinitionDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.EventDeploymentDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.EventResourceDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.TableDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.impl.MybatisChannelDefinitionDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.impl.MybatisEventDefinitionDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.impl.MybatisEventDeploymentDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.impl.MybatisEventResourceDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.impl.TableDataManagerImpl;
import org.flowable.eventregistry.impl.pipeline.DelegateExpressionInboundChannelModelProcessor;
import org.flowable.eventregistry.impl.pipeline.DelegateExpressionOutboundChannelModelProcessor;
import org.flowable.eventregistry.impl.pipeline.InboundChannelModelProcessor;
import org.flowable.eventregistry.impl.pipeline.OutboundChannelModelProcessor;
import org.flowable.eventregistry.json.converter.ChannelJsonConverter;
import org.flowable.eventregistry.json.converter.EventJsonConverter;

public class EventRegistryEngineConfiguration
extends AbstractEngineConfiguration
implements EventRegistryConfigurationApi,
HasExpressionManagerEngineConfiguration {
    public static final String DEFAULT_MYBATIS_MAPPING_FILE = "org/flowable/eventregistry/db/mapping/mappings.xml";
    public static final String LIQUIBASE_CHANGELOG_PREFIX = "FLW_EV_";
    protected String eventRegistryEngineName = "default";
    protected EventRepositoryService eventRepositoryService = new EventRepositoryServiceImpl(this);
    protected EventManagementService eventManagementService = new EventManagementServiceImpl(this);
    protected EventDeploymentDataManager deploymentDataManager;
    protected EventDefinitionDataManager eventDefinitionDataManager;
    protected ChannelDefinitionDataManager channelDefinitionDataManager;
    protected EventResourceDataManager resourceDataManager;
    protected EventDeploymentEntityManager deploymentEntityManager;
    protected EventDefinitionEntityManager eventDefinitionEntityManager;
    protected ChannelDefinitionEntityManager channelDefinitionEntityManager;
    protected EventResourceEntityManager resourceEntityManager;
    protected TableDataManager tableDataManager;
    protected ExpressionManager expressionManager;
    protected EventJsonConverter eventJsonConverter = new EventJsonConverter();
    protected ChannelJsonConverter channelJsonConverter = new ChannelJsonConverter();
    protected EventDefinitionDeployer eventDeployer;
    protected EventDefinitionParseFactory eventParseFactory;
    protected ChannelDefinitionParseFactory channelParseFactory;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected EventDefinitionDeploymentHelper eventDeploymentHelper;
    protected ChannelDefinitionDeploymentHelper channelDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;
    protected List<Deployer> customPreDeployers;
    protected List<Deployer> customPostDeployers;
    protected List<Deployer> deployers;
    protected EventDeploymentManager deploymentManager;
    protected int eventDefinitionCacheLimit = -1;
    protected DeploymentCache<EventDefinitionCacheEntry> eventDefinitionCache;
    protected DeploymentCache<ChannelDefinitionCacheEntry> channelDefinitionCache;
    protected Collection<ChannelModelProcessor> channelModelProcessors = new ArrayList<ChannelModelProcessor>();
    protected EventRegistry eventRegistry;
    protected InboundEventProcessor inboundEventProcessor;
    protected OutboundEventProcessor outboundEventProcessor;
    protected boolean enableEventRegistryChangeDetection;
    protected long eventRegistryChangeDetectionInitialDelayInMs = 10000L;
    protected long eventRegistryChangeDetectionDelayInMs = 60000L;
    protected EventRegistryChangeDetectionManager eventRegistryChangeDetectionManager;
    protected EventRegistryChangeDetectionExecutor eventRegistryChangeDetectionExecutor;
    protected boolean enableEventRegistryChangeDetectionAfterEngineCreate = true;

    public static EventRegistryEngineConfiguration createEventRegistryEngineConfigurationFromResourceDefault() {
        return EventRegistryEngineConfiguration.createEventRegistryEngineConfigurationFromResource("flowable.eventregistry.cfg.xml", "eventRegistryEngineConfiguration");
    }

    public static EventRegistryEngineConfiguration createEventRegistryEngineConfigurationFromResource(String resource) {
        return EventRegistryEngineConfiguration.createEventRegistryEngineConfigurationFromResource(resource, "eventRegistryEngineConfiguration");
    }

    public static EventRegistryEngineConfiguration createEventRegistryEngineConfigurationFromResource(String resource, String beanName) {
        return (EventRegistryEngineConfiguration)BeansConfigurationHelper.parseEngineConfigurationFromResource((String)resource, (String)beanName);
    }

    public static EventRegistryEngineConfiguration createEventRegistryEngineConfigurationFromInputStream(InputStream inputStream) {
        return EventRegistryEngineConfiguration.createEventRegistryEngineConfigurationFromInputStream(inputStream, "eventRegistryEngineConfiguration");
    }

    public static EventRegistryEngineConfiguration createEventRegistryEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        return (EventRegistryEngineConfiguration)BeansConfigurationHelper.parseEngineConfigurationFromInputStream((InputStream)inputStream, (String)beanName);
    }

    public static EventRegistryEngineConfiguration createStandaloneEventRegistryEngineConfiguration() {
        return new StandaloneEventRegistryEngineConfiguration();
    }

    public static EventRegistryEngineConfiguration createStandaloneInMemEventRegistryEngineConfiguration() {
        return new StandaloneInMemEventRegistryEngineConfiguration();
    }

    public EventRegistryEngine buildEventRegistryEngine() {
        this.init();
        EventRegistryEngineImpl eventRegistryEngine = new EventRegistryEngineImpl(this);
        if (this.enableEventRegistryChangeDetectionAfterEngineCreate) {
            eventRegistryEngine.handleDeployedChannelDefinitions();
            if (this.enableEventRegistryChangeDetection) {
                this.eventRegistryChangeDetectionExecutor.initialize();
            }
        }
        return eventRegistryEngine;
    }

    protected void init() {
        this.initEngineConfigurations();
        this.initConfigurators();
        this.configuratorsBeforeInit();
        this.initExpressionManager();
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initIdGenerator();
        if (this.usingRelationalDatabase) {
            this.initDataSource();
        }
        if (this.usingRelationalDatabase || this.usingSchemaMgmt) {
            this.initSchemaManager();
            this.initSchemaManagementCommand();
        }
        this.initBeans();
        this.initTransactionFactory();
        if (this.usingRelationalDatabase) {
            this.initSqlSessionFactory();
        }
        this.initSessionFactories();
        this.initServices();
        this.configuratorsAfterInit();
        this.initDataManagers();
        this.initEntityManagers();
        this.initEventRegistry();
        this.initInboundEventProcessor();
        this.initOutboundEventProcessor();
        this.initChannelDefinitionProcessors();
        this.initDeployers();
        this.initClock();
        this.initChangeDetectionManager();
        this.initChangeDetectionExecutor();
    }

    protected void initServices() {
        this.initService(this.eventRepositoryService);
        this.initService(this.eventManagementService);
    }

    public void initExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = new DefaultExpressionManager(this.beans);
        }
    }

    public void initDataManagers() {
        super.initDataManagers();
        if (this.deploymentDataManager == null) {
            this.deploymentDataManager = new MybatisEventDeploymentDataManager(this);
        }
        if (this.eventDefinitionDataManager == null) {
            this.eventDefinitionDataManager = new MybatisEventDefinitionDataManager(this);
        }
        if (this.channelDefinitionDataManager == null) {
            this.channelDefinitionDataManager = new MybatisChannelDefinitionDataManager(this);
        }
        if (this.resourceDataManager == null) {
            this.resourceDataManager = new MybatisEventResourceDataManager(this);
        }
    }

    public void initEntityManagers() {
        super.initEntityManagers();
        if (this.deploymentEntityManager == null) {
            this.deploymentEntityManager = new EventDeploymentEntityManagerImpl(this, this.deploymentDataManager);
        }
        if (this.eventDefinitionEntityManager == null) {
            this.eventDefinitionEntityManager = new EventDefinitionEntityManagerImpl(this, this.eventDefinitionDataManager);
        }
        if (this.channelDefinitionEntityManager == null) {
            this.channelDefinitionEntityManager = new ChannelDefinitionEntityManagerImpl(this, this.channelDefinitionDataManager);
        }
        if (this.resourceEntityManager == null) {
            this.resourceEntityManager = new EventResourceEntityManagerImpl(this, this.resourceDataManager);
        }
        if (this.tableDataManager == null) {
            this.tableDataManager = new TableDataManagerImpl();
        }
    }

    public void initSchemaManager() {
        super.initSchemaManager();
        if (this.schemaManager == null) {
            this.schemaManager = new EventDbSchemaManager();
        }
    }

    public void initSchemaManagementCommand() {
        if (this.schemaManagementCmd == null && this.usingRelationalDatabase && this.databaseSchemaUpdate != null) {
            this.schemaManagementCmd = new SchemaOperationsEventRegistryEngineBuild();
        }
    }

    private void closeDatabase(Liquibase liquibase) {
        Database database;
        if (liquibase != null && (database = liquibase.getDatabase()) != null) {
            try {
                database.close();
            }
            catch (DatabaseException e) {
                this.logger.warn("Error closing database", (Throwable)e);
            }
        }
    }

    public void initDbSqlSessionFactory() {
        if (this.dbSqlSessionFactory == null) {
            this.dbSqlSessionFactory = this.createDbSqlSessionFactory();
            this.dbSqlSessionFactory.setDatabaseType(this.databaseType);
            this.dbSqlSessionFactory.setSqlSessionFactory(this.sqlSessionFactory);
            this.dbSqlSessionFactory.setDatabaseTablePrefix(this.databaseTablePrefix);
            this.dbSqlSessionFactory.setTablePrefixIsSchema(this.tablePrefixIsSchema);
            this.dbSqlSessionFactory.setDatabaseCatalog(this.databaseCatalog);
            this.dbSqlSessionFactory.setDatabaseSchema(this.databaseSchema);
            this.addSessionFactory((SessionFactory)this.dbSqlSessionFactory);
        }
        this.initDbSqlSessionFactoryEntitySettings();
    }

    protected void initDbSqlSessionFactoryEntitySettings() {
        this.defaultInitDbSqlSessionFactoryEntitySettings(EntityDependencyOrder.INSERT_ORDER, EntityDependencyOrder.DELETE_ORDER);
    }

    public DbSqlSessionFactory createDbSqlSessionFactory() {
        return new DbSqlSessionFactory(this.usePrefixId);
    }

    public void initCommandExecutors() {
        this.initDefaultCommandConfig();
        this.initSchemaCommandConfig();
        this.initCommandInvoker();
        this.initCommandInterceptors();
        this.initCommandExecutor();
    }

    public void initCommandInterceptors() {
        if (this.commandInterceptors == null) {
            this.commandInterceptors = new ArrayList();
            if (this.customPreCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPreCommandInterceptors);
            }
            this.commandInterceptors.addAll(this.getDefaultCommandInterceptors());
            if (this.customPostCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPostCommandInterceptors);
            }
            this.commandInterceptors.add(this.commandInvoker);
        }
    }

    public String getEngineCfgKey() {
        return "cfg.eventRegistry";
    }

    public CommandInterceptor createTransactionInterceptor() {
        return null;
    }

    protected void initDeployers() {
        if (this.eventParseFactory == null) {
            this.eventParseFactory = new EventDefinitionParseFactory();
        }
        if (this.channelParseFactory == null) {
            this.channelParseFactory = new ChannelDefinitionParseFactory();
        }
        if (this.eventDeployer == null) {
            this.deployers = new ArrayList<Deployer>();
            if (this.customPreDeployers != null) {
                this.deployers.addAll(this.customPreDeployers);
            }
            this.deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                this.deployers.addAll(this.customPostDeployers);
            }
        }
        if (this.eventDefinitionCache == null) {
            this.eventDefinitionCache = this.eventDefinitionCacheLimit <= 0 ? new DefaultDeploymentCache() : new DefaultDeploymentCache(this.eventDefinitionCacheLimit);
        }
        if (this.channelDefinitionCache == null) {
            this.channelDefinitionCache = new FullDeploymentCache();
        }
        this.deploymentManager = new EventDeploymentManager(this.eventDefinitionCache, this.channelDefinitionCache, this);
        this.deploymentManager.setDeployers(this.deployers);
        this.deploymentManager.setDeploymentEntityManager(this.deploymentEntityManager);
        this.deploymentManager.setEventDefinitionEntityManager(this.eventDefinitionEntityManager);
        this.deploymentManager.setChannelDefinitionEntityManager(this.channelDefinitionEntityManager);
    }

    public Collection<? extends Deployer> getDefaultDeployers() {
        ArrayList<EventDefinitionDeployer> defaultDeployers = new ArrayList<EventDefinitionDeployer>();
        if (this.eventDeployer == null) {
            this.eventDeployer = new EventDefinitionDeployer();
        }
        this.initEventDeployerDependencies();
        this.eventDeployer.setIdGenerator(this.idGenerator);
        this.eventDeployer.setParsedDeploymentBuilderFactory(this.parsedDeploymentBuilderFactory);
        this.eventDeployer.setEventDeploymentHelper(this.eventDeploymentHelper);
        this.eventDeployer.setChannelDeploymentHelper(this.channelDeploymentHelper);
        this.eventDeployer.setCachingAndArtifactsManager(this.cachingAndArtifactsManager);
        this.eventDeployer.setUsePrefixId(this.usePrefixId);
        defaultDeployers.add(this.eventDeployer);
        return defaultDeployers;
    }

    public void initEventDeployerDependencies() {
        if (this.parsedDeploymentBuilderFactory == null) {
            this.parsedDeploymentBuilderFactory = new ParsedDeploymentBuilderFactory();
        }
        if (this.parsedDeploymentBuilderFactory.getEventParseFactory() == null) {
            this.parsedDeploymentBuilderFactory.setEventParseFactory(this.eventParseFactory);
        }
        if (this.parsedDeploymentBuilderFactory.getChannelParseFactory() == null) {
            this.parsedDeploymentBuilderFactory.setChannelParseFactory(this.channelParseFactory);
        }
        if (this.eventDeploymentHelper == null) {
            this.eventDeploymentHelper = new EventDefinitionDeploymentHelper();
        }
        if (this.channelDeploymentHelper == null) {
            this.channelDeploymentHelper = new ChannelDefinitionDeploymentHelper();
        }
        if (this.cachingAndArtifactsManager == null) {
            this.cachingAndArtifactsManager = new CachingAndArtifactsManager();
        }
    }

    public void initEventRegistry() {
        if (this.eventRegistry == null) {
            this.eventRegistry = new DefaultEventRegistry(this);
        }
    }

    public void initInboundEventProcessor() {
        if (this.inboundEventProcessor == null) {
            this.inboundEventProcessor = new DefaultInboundEventProcessor(this.eventRegistry);
        }
        this.eventRegistry.setInboundEventProcessor(this.inboundEventProcessor);
    }

    public void initOutboundEventProcessor() {
        if (this.outboundEventProcessor == null) {
            this.outboundEventProcessor = new DefaultOutboundEventProcessor(this.eventRepositoryService, this.fallbackToDefaultTenant);
        }
        this.eventRegistry.setOutboundEventProcessor(this.outboundEventProcessor);
    }

    public void initChannelDefinitionProcessors() {
        this.channelModelProcessors.add(new DelegateExpressionInboundChannelModelProcessor(this));
        this.channelModelProcessors.add(new DelegateExpressionOutboundChannelModelProcessor(this));
        this.channelModelProcessors.add(new InboundChannelModelProcessor());
        this.channelModelProcessors.add(new OutboundChannelModelProcessor());
    }

    public void initChangeDetectionManager() {
        if (this.eventRegistryChangeDetectionManager == null) {
            this.eventRegistryChangeDetectionManager = new DefaultEventRegistryChangeDetectionManager(this);
        }
    }

    public void initChangeDetectionExecutor() {
        if (this.eventRegistryChangeDetectionExecutor == null) {
            this.eventRegistryChangeDetectionExecutor = new DefaultEventRegistryChangeDetectionExecutor(this.eventRegistryChangeDetectionManager, this.eventRegistryChangeDetectionInitialDelayInMs, this.eventRegistryChangeDetectionDelayInMs);
        }
    }

    public InputStream getMyBatisXmlConfigurationStream() {
        return this.getResourceAsStream(DEFAULT_MYBATIS_MAPPING_FILE);
    }

    public String getEngineName() {
        return this.eventRegistryEngineName;
    }

    public EventRegistryEngineConfiguration setEngineName(String eventRegistryEngineName) {
        this.eventRegistryEngineName = eventRegistryEngineName;
        return this;
    }

    public EventRepositoryService getEventRepositoryService() {
        return this.eventRepositoryService;
    }

    public EventRegistryEngineConfiguration setEventRepositoryService(EventRepositoryService eventRepositoryService) {
        this.eventRepositoryService = eventRepositoryService;
        return this;
    }

    public EventManagementService getEventManagementService() {
        return this.eventManagementService;
    }

    public EventRegistryEngineConfiguration setEventManagementService(EventManagementService eventManagementService) {
        this.eventManagementService = eventManagementService;
        return this;
    }

    public EventDeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public EventRegistryEngineConfiguration getFormEngineConfiguration() {
        return this;
    }

    public EventDefinitionDeployer getEventDeployer() {
        return this.eventDeployer;
    }

    public EventRegistryEngineConfiguration setEventDeployer(EventDefinitionDeployer eventDeployer) {
        this.eventDeployer = eventDeployer;
        return this;
    }

    public EventDefinitionParseFactory getEventParseFactory() {
        return this.eventParseFactory;
    }

    public EventRegistryEngineConfiguration setEventParseFactory(EventDefinitionParseFactory eventParseFactory) {
        this.eventParseFactory = eventParseFactory;
        return this;
    }

    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    public EventRegistryEngineConfiguration setEventRegistry(EventRegistry eventRegistry) {
        this.eventRegistry = eventRegistry;
        return this;
    }

    public InboundEventProcessor getInboundEventProcessor() {
        return this.inboundEventProcessor;
    }

    public EventRegistryEngineConfiguration setInboundEventProcessor(InboundEventProcessor inboundEventProcessor) {
        this.inboundEventProcessor = inboundEventProcessor;
        return this;
    }

    public OutboundEventProcessor getOutboundEventProcessor() {
        return this.outboundEventProcessor;
    }

    public EventRegistryEngineConfiguration setOutboundEventProcessor(OutboundEventProcessor outboundEventProcessor) {
        this.outboundEventProcessor = outboundEventProcessor;
        return this;
    }

    public boolean isEnableEventRegistryChangeDetection() {
        return this.enableEventRegistryChangeDetection;
    }

    public EventRegistryEngineConfiguration setEnableEventRegistryChangeDetection(boolean enableEventRegistryChangeDetection) {
        this.enableEventRegistryChangeDetection = enableEventRegistryChangeDetection;
        return this;
    }

    public long getEventRegistryChangeDetectionInitialDelayInMs() {
        return this.eventRegistryChangeDetectionInitialDelayInMs;
    }

    public EventRegistryEngineConfiguration setEventRegistryChangeDetectionInitialDelayInMs(long eventRegistryChangeDetectionInitialDelayInMs) {
        this.eventRegistryChangeDetectionInitialDelayInMs = eventRegistryChangeDetectionInitialDelayInMs;
        return this;
    }

    public long getEventRegistryChangeDetectionDelayInMs() {
        return this.eventRegistryChangeDetectionDelayInMs;
    }

    public EventRegistryEngineConfiguration setEventRegistryChangeDetectionDelayInMs(long eventRegistryChangeDetectionDelayInMs) {
        this.eventRegistryChangeDetectionDelayInMs = eventRegistryChangeDetectionDelayInMs;
        return this;
    }

    public EventRegistryChangeDetectionManager getEventRegistryChangeDetectionManager() {
        return this.eventRegistryChangeDetectionManager;
    }

    public EventRegistryEngineConfiguration setEventRegistryChangeDetectionManager(EventRegistryChangeDetectionManager eventRegistryChangeDetectionManager) {
        this.eventRegistryChangeDetectionManager = eventRegistryChangeDetectionManager;
        return this;
    }

    public EventRegistryChangeDetectionExecutor getEventRegistryChangeDetectionExecutor() {
        return this.eventRegistryChangeDetectionExecutor;
    }

    public EventRegistryEngineConfiguration setEventRegistryChangeDetectionExecutor(EventRegistryChangeDetectionExecutor eventRegistryChangeDetectionExecutor) {
        this.eventRegistryChangeDetectionExecutor = eventRegistryChangeDetectionExecutor;
        return this;
    }

    public int getEventDefinitionCacheLimit() {
        return this.eventDefinitionCacheLimit;
    }

    public EventRegistryEngineConfiguration setEventDefinitionCacheLimit(int eventDefinitionCacheLimit) {
        this.eventDefinitionCacheLimit = eventDefinitionCacheLimit;
        return this;
    }

    public DeploymentCache<EventDefinitionCacheEntry> getEventDefinitionCache() {
        return this.eventDefinitionCache;
    }

    public EventRegistryEngineConfiguration setEventDefinitionCache(DeploymentCache<EventDefinitionCacheEntry> eventDefinitionCache) {
        this.eventDefinitionCache = eventDefinitionCache;
        return this;
    }

    public DeploymentCache<ChannelDefinitionCacheEntry> getChannelDefinitionCache() {
        return this.channelDefinitionCache;
    }

    public EventRegistryEngineConfiguration setChannelDefinitionCache(DeploymentCache<ChannelDefinitionCacheEntry> channelDefinitionCache) {
        this.channelDefinitionCache = channelDefinitionCache;
        return this;
    }

    public Collection<ChannelModelProcessor> getChannelModelProcessors() {
        return this.channelModelProcessors;
    }

    public void addChannelModelProcessor(ChannelModelProcessor channelModelProcessor) {
        if (this.channelModelProcessors == null) {
            this.channelModelProcessors = new ArrayList<ChannelModelProcessor>();
        }
        this.channelModelProcessors.add(channelModelProcessor);
    }

    public void setChannelModelProcessors(Collection<ChannelModelProcessor> channelModelProcessors) {
        this.channelModelProcessors = channelModelProcessors;
    }

    public EventDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public EventRegistryEngineConfiguration setDeploymentDataManager(EventDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
        return this;
    }

    public EventDefinitionDataManager getEventDefinitionDataManager() {
        return this.eventDefinitionDataManager;
    }

    public EventRegistryEngineConfiguration setEventDefinitionDataManager(EventDefinitionDataManager eventDefinitionDataManager) {
        this.eventDefinitionDataManager = eventDefinitionDataManager;
        return this;
    }

    public EventResourceDataManager getResourceDataManager() {
        return this.resourceDataManager;
    }

    public EventRegistryEngineConfiguration setResourceDataManager(EventResourceDataManager resourceDataManager) {
        this.resourceDataManager = resourceDataManager;
        return this;
    }

    public EventDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public EventRegistryEngineConfiguration setDeploymentEntityManager(EventDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
        return this;
    }

    public EventDefinitionEntityManager getEventDefinitionEntityManager() {
        return this.eventDefinitionEntityManager;
    }

    public EventRegistryEngineConfiguration setEventDefinitionEntityManager(EventDefinitionEntityManager eventDefinitionEntityManager) {
        this.eventDefinitionEntityManager = eventDefinitionEntityManager;
        return this;
    }

    public ChannelDefinitionEntityManager getChannelDefinitionEntityManager() {
        return this.channelDefinitionEntityManager;
    }

    public EventRegistryEngineConfiguration setChannelDefinitionEntityManager(ChannelDefinitionEntityManager channelDefinitionEntityManager) {
        this.channelDefinitionEntityManager = channelDefinitionEntityManager;
        return this;
    }

    public EventResourceEntityManager getResourceEntityManager() {
        return this.resourceEntityManager;
    }

    public EventRegistryEngineConfiguration setResourceEntityManager(EventResourceEntityManager resourceEntityManager) {
        this.resourceEntityManager = resourceEntityManager;
        return this;
    }

    public TableDataManager getTableDataManager() {
        return this.tableDataManager;
    }

    public EventRegistryEngineConfiguration setTableDataManager(TableDataManager tableDataManager) {
        this.tableDataManager = tableDataManager;
        return this;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public EventRegistryEngineConfiguration setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    public EventJsonConverter getEventJsonConverter() {
        return this.eventJsonConverter;
    }

    public EventRegistryEngineConfiguration setEventJsonConverter(EventJsonConverter eventJsonConverter) {
        this.eventJsonConverter = eventJsonConverter;
        return this;
    }

    public ChannelJsonConverter getChannelJsonConverter() {
        return this.channelJsonConverter;
    }

    public EventRegistryEngineConfiguration setChannelJsonConverter(ChannelJsonConverter channelJsonConverter) {
        this.channelJsonConverter = channelJsonConverter;
        return this;
    }

    public boolean isEnableEventRegistryChangeDetectionAfterEngineCreate() {
        return this.enableEventRegistryChangeDetectionAfterEngineCreate;
    }

    public EventRegistryEngineConfiguration setEnableEventRegistryChangeDetectionAfterEngineCreate(boolean enableEventRegistryChangeDetectionAfterEngineCreate) {
        this.enableEventRegistryChangeDetectionAfterEngineCreate = enableEventRegistryChangeDetectionAfterEngineCreate;
        return this;
    }
}

