/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.persistence.entity;

import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.event.FlowableEntityEventImpl;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.EntityManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public abstract class AbstractEntityManager<EntityImpl extends Entity, DM extends DataManager<EntityImpl>>
implements EntityManager<EntityImpl> {
    protected DM dataManager;

    public AbstractEntityManager(DM dataManager) {
        this.dataManager = dataManager;
    }

    @Override
    public EntityImpl findById(String entityId) {
        return this.getDataManager().findById(entityId);
    }

    @Override
    public EntityImpl create() {
        return this.getDataManager().create();
    }

    @Override
    public void insert(EntityImpl entity) {
        this.insert(entity, true);
    }

    @Override
    public void insert(EntityImpl entity, boolean fireCreateEvent) {
        this.getDataManager().insert(entity);
        if (fireCreateEvent) {
            this.fireEntityInsertedEvent((Entity)entity);
        }
    }

    protected void fireEntityInsertedEvent(Entity entity) {
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)this.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, entity));
            eventDispatcher.dispatchEvent((FlowableEvent)this.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, entity));
        }
    }

    @Override
    public EntityImpl update(EntityImpl entity) {
        return this.update(entity, true);
    }

    @Override
    public EntityImpl update(EntityImpl entity, boolean fireUpdateEvent) {
        EntityImpl updatedEntity = this.getDataManager().update(entity);
        if (fireUpdateEvent) {
            this.fireEntityUpdatedEvent((Entity)entity);
        }
        return updatedEntity;
    }

    protected void fireEntityUpdatedEvent(Entity entity) {
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)this.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, entity));
        }
    }

    @Override
    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    @Override
    public void delete(EntityImpl entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(EntityImpl entity, boolean fireDeleteEvent) {
        this.getDataManager().delete(entity);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireDeleteEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            this.fireEntityDeletedEvent((Entity)entity);
        }
    }

    protected void fireEntityDeletedEvent(Entity entity) {
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)this.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, entity));
        }
    }

    protected FlowableEntityEvent createEntityEvent(FlowableEngineEventType eventType, Entity entity) {
        return new FlowableEntityEventImpl(entity, eventType);
    }

    protected DM getDataManager() {
        return this.dataManager;
    }

    protected void setDataManager(DM dataManager) {
        this.dataManager = dataManager;
    }

    protected abstract FlowableEventDispatcher getEventDispatcher();
}

