/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.interceptor;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContextInterceptor
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandContextInterceptor.class);
    protected CommandContextFactory commandContextFactory;
    protected String currentEngineConfigurationKey;
    protected Map<String, AbstractEngineConfiguration> engineConfigurations = new HashMap<String, AbstractEngineConfiguration>();
    protected Map<String, AbstractServiceConfiguration> serviceConfigurations = new HashMap<String, AbstractServiceConfiguration>();

    public CommandContextInterceptor() {
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext commandContext = Context.getCommandContext();
        boolean contextReused = false;
        AbstractEngineConfiguration previousEngineConfiguration = null;
        if (!config.isContextReusePossible() || commandContext == null || commandContext.getException() != null) {
            commandContext = this.commandContextFactory.createCommandContext(command);
            commandContext.setEngineConfigurations(this.engineConfigurations);
        } else {
            LOGGER.debug("Valid context found. Reusing it for the current command '{}'", (Object)command.getClass().getCanonicalName());
            contextReused = true;
            commandContext.setReused(true);
            previousEngineConfiguration = commandContext.getCurrentEngineConfiguration();
        }
        try {
            commandContext.setCurrentEngineConfiguration(this.engineConfigurations.get(this.currentEngineConfigurationKey));
            Context.setCommandContext(commandContext);
            T t = this.next.execute(config, command);
            return t;
        }
        catch (Exception e) {
            commandContext.exception(e);
        }
        finally {
            try {
                if (!contextReused) {
                    commandContext.close();
                }
            }
            finally {
                Context.removeCommandContext();
                commandContext.setCurrentEngineConfiguration(previousEngineConfiguration);
            }
        }
        return null;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public String getCurrentEngineConfigurationKey() {
        return this.currentEngineConfigurationKey;
    }

    public void setCurrentEngineConfigurationKey(String currentEngineConfigurationKey) {
        this.currentEngineConfigurationKey = currentEngineConfigurationKey;
    }

    public Map<String, AbstractEngineConfiguration> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    public void setEngineConfigurations(Map<String, AbstractEngineConfiguration> engineConfigurations) {
        this.engineConfigurations = engineConfigurations;
    }

    public Map<String, AbstractServiceConfiguration> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public void setServiceConfigurations(Map<String, AbstractServiceConfiguration> serviceConfigurations) {
        this.serviceConfigurations = serviceConfigurations;
    }
}

