/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class ActivityStartHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public List<String> getTypes() {
        return Collections.singletonList("activity-start");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricActivityInstanceEntityManager();
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.createHistoricActivityInstanceEntity(historicalData, commandContext, historicActivityInstanceEntityManager);
        historicActivityInstanceEntity.setProcessDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionId"));
        historicActivityInstanceEntity.setProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId"));
        historicActivityInstanceEntity.setExecutionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId"));
        historicActivityInstanceEntity.setActivityId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId"));
        historicActivityInstanceEntity.setActivityName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityName"));
        historicActivityInstanceEntity.setActivityType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityType"));
        historicActivityInstanceEntity.setAssignee(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"assignee"));
        historicActivityInstanceEntity.setStartTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"startTime"));
        historicActivityInstanceEntity.setTenantId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"tenantId"));
        historicActivityInstanceEntityManager.insert(historicActivityInstanceEntity);
        this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_CREATED, historicActivityInstanceEntity));
    }
}

