/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public class ErrorPropagation {
    public static void propagateError(BpmnError error, DelegateExecution execution) {
        ErrorPropagation.propagateError(error.getErrorCode(), execution);
    }

    public static void propagateError(String errorCode, DelegateExecution execution) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        HashSet<String> rootProcessDefinitionIds = new HashSet<String>();
        if (!execution.getProcessInstanceId().equals(execution.getRootProcessInstanceId())) {
            ExecutionEntity parentExecution = (ExecutionEntity)execution;
            while (parentExecution.getParentId() != null || parentExecution.getSuperExecutionId() != null) {
                if (parentExecution.getParentId() != null) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                parentExecution = parentExecution.getSuperExecution();
                rootProcessDefinitionIds.add(parentExecution.getProcessDefinitionId());
            }
        }
        if (rootProcessDefinitionIds.size() > 0) {
            for (String processDefinitionId : rootProcessDefinitionIds) {
                eventMap.putAll(ErrorPropagation.findCatchingEventsForProcess(processDefinitionId, errorCode));
            }
        }
        eventMap.putAll(ErrorPropagation.findCatchingEventsForProcess(execution.getProcessDefinitionId(), errorCode));
        if (eventMap.size() > 0) {
            ErrorPropagation.executeCatch(eventMap, execution, errorCode);
        }
        if (eventMap.size() == 0) {
            throw new BpmnError(errorCode, "No catching boundary event found for error with errorCode '" + errorCode + "', neither in same process nor in parent process");
        }
    }

    protected static void executeCatch(Map<String, List<Event>> eventMap, DelegateExecution delegateExecution, String errorId) {
        HashSet<String> toDeleteProcessInstanceIds = new HashSet<String>();
        Event matchingEvent = null;
        ExecutionEntity currentExecution = (ExecutionEntity)delegateExecution;
        ExecutionEntity parentExecution = null;
        if (eventMap.containsKey(currentExecution.getActivityId() + "#" + currentExecution.getProcessDefinitionId())) {
            parentExecution = currentExecution.getParentId() != null && currentExecution.getParent().isMultiInstanceRoot() ? currentExecution.getParent() : currentExecution;
            matchingEvent = ErrorPropagation.getCatchEventFromList(eventMap.get(currentExecution.getActivityId() + "#" + currentExecution.getProcessDefinitionId()), parentExecution);
        } else {
            parentExecution = currentExecution.getParent();
            while (matchingEvent == null && parentExecution != null) {
                FlowElementsContainer currentContainer = null;
                if (parentExecution.getCurrentFlowElement() instanceof FlowElementsContainer) {
                    currentContainer = (FlowElementsContainer)parentExecution.getCurrentFlowElement();
                } else if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                    currentContainer = ProcessDefinitionUtil.getProcess(parentExecution.getProcessDefinitionId());
                }
                if (currentContainer != null) {
                    for (String refId : eventMap.keySet()) {
                        String errorCode;
                        List<Event> events = eventMap.get(refId);
                        if (!CollectionUtil.isNotEmpty(events) || !(events.get(0) instanceof StartEvent)) continue;
                        String refActivityId = refId.substring(0, refId.indexOf(35));
                        String refProcessDefinitionId = refId.substring(refId.indexOf(35) + 1);
                        if (!parentExecution.getProcessDefinitionId().equals(refProcessDefinitionId) || currentContainer.getFlowElement(refActivityId) == null || !StringUtils.isNotEmpty((CharSequence)(errorCode = ErrorPropagation.getErrorCodeFromErrorEventDefinition(matchingEvent = ErrorPropagation.getCatchEventFromList(events, parentExecution))))) continue;
                        break;
                    }
                }
                if (matchingEvent != null) continue;
                if (eventMap.containsKey(parentExecution.getActivityId() + "#" + parentExecution.getProcessDefinitionId())) {
                    if (parentExecution.getParentId() != null && parentExecution.getParent().isMultiInstanceRoot()) {
                        parentExecution = parentExecution.getParent();
                    }
                    matchingEvent = ErrorPropagation.getCatchEventFromList(eventMap.get(parentExecution.getActivityId() + "#" + parentExecution.getProcessDefinitionId()), parentExecution);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)parentExecution.getParentId())) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                if (!parentExecution.getProcessInstanceId().equals(parentExecution.getRootProcessInstanceId())) {
                    toDeleteProcessInstanceIds.add(parentExecution.getProcessInstanceId());
                    parentExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (matchingEvent != null && parentExecution != null) {
            for (String processInstanceId : toDeleteProcessInstanceIds) {
                ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
                ExecutionEntity processInstanceEntity = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
                executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceEntity.getId(), currentExecution.getCurrentFlowElement() != null ? currentExecution.getCurrentFlowElement().getId() : null, "ERROR_EVENT " + errorId, false, false, false);
                if (CommandContextUtil.getProcessEngineConfiguration() == null || !CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
                CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, processInstanceEntity));
            }
        } else {
            throw new FlowableException("No matching parent execution for error code " + errorId + " found");
        }
        ErrorPropagation.executeEventHandler(matchingEvent, parentExecution, currentExecution, errorId);
    }

    protected static void executeEventHandler(Event event, ExecutionEntity parentExecution, ExecutionEntity currentExecution, String errorId) {
        BpmnModel bpmnModel;
        if (CommandContextUtil.getProcessEngineConfiguration() != null && CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId())) != null) {
            String errorCode = (String)bpmnModel.getErrors().get(errorId);
            if (errorCode == null) {
                errorCode = errorId;
            }
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createErrorEvent(FlowableEngineEventType.ACTIVITY_ERROR_RECEIVED, event.getId(), errorId, errorCode, parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId()));
        }
        if (event instanceof StartEvent) {
            ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
            if (parentExecution.isProcessInstanceType()) {
                executionEntityManager.deleteChildExecutions(parentExecution, null, true);
            } else if (!currentExecution.getParentId().equals(parentExecution.getId())) {
                CommandContextUtil.getAgenda().planDestroyScopeOperation(currentExecution);
            } else {
                executionEntityManager.deleteExecutionAndRelatedData(currentExecution, null);
            }
            ExecutionEntity eventSubProcessExecution = executionEntityManager.createChildExecution(parentExecution);
            eventSubProcessExecution.setCurrentFlowElement((FlowElement)(event.getSubProcess() != null ? event.getSubProcess() : event));
            CommandContextUtil.getAgenda().planContinueProcessOperation(eventSubProcessExecution);
        } else {
            ExecutionEntity boundaryExecution = null;
            List<? extends ExecutionEntity> childExecutions = parentExecution.getExecutions();
            for (ExecutionEntity executionEntity : childExecutions) {
                if (executionEntity == null || executionEntity.getActivityId() == null || !executionEntity.getActivityId().equals(event.getId())) continue;
                boundaryExecution = executionEntity;
            }
            CommandContextUtil.getAgenda().planTriggerExecutionOperation(boundaryExecution);
        }
    }

    protected static Map<String, List<Event>> findCatchingEventsForProcess(String processDefinitionId, String errorCode) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        String compareErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorCode);
        List subProcesses = process.findFlowElementsOfType(EventSubProcess.class, true);
        for (EventSubProcess eventSubProcess : subProcesses) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                ErrorEventDefinition errorEventDef;
                String eventErrorCode;
                StartEvent startEvent;
                if (!(flowElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)startEvent.getEventDefinitions().get(0)).getErrorCode())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
                ArrayList<StartEvent> startEvents = new ArrayList<StartEvent>();
                startEvents.add(startEvent);
                eventMap.put(eventSubProcess.getId() + "#" + processDefinitionId, startEvents);
            }
        }
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            ErrorEventDefinition errorEventDef;
            String eventErrorCode;
            if (boundaryEvent.getAttachedToRefId() == null || !CollectionUtil.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)boundaryEvent.getEventDefinitions().get(0)).getErrorCode())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
            List<BoundaryEvent> elementBoundaryEvents = null;
            if (!eventMap.containsKey(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId)) {
                elementBoundaryEvents = new ArrayList();
                eventMap.put(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId, elementBoundaryEvents);
            } else {
                elementBoundaryEvents = (List)eventMap.get(boundaryEvent.getAttachedToRefId() + "#" + processDefinitionId);
            }
            elementBoundaryEvents.add(boundaryEvent);
        }
        return eventMap;
    }

    public static boolean mapException(Exception e, ExecutionEntity execution, List<MapExceptionEntry> exceptionMap) {
        CallActivity callActivity;
        String errorCode = ErrorPropagation.findMatchingExceptionMapping(e, exceptionMap);
        if (errorCode != null) {
            ErrorPropagation.propagateError(errorCode, (DelegateExecution)execution);
            return true;
        }
        DelegateExecution callActivityExecution = null;
        ExecutionEntity parentExecution = execution.getParent();
        while (parentExecution != null && callActivityExecution == null) {
            if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                if (parentExecution.getSuperExecution() != null) {
                    callActivityExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
                continue;
            }
            parentExecution = parentExecution.getParent();
        }
        if (callActivityExecution != null && CollectionUtil.isNotEmpty((Collection)(callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement()).getMapExceptions()) && (errorCode = ErrorPropagation.findMatchingExceptionMapping(e, callActivity.getMapExceptions())) != null) {
            ErrorPropagation.propagateError(errorCode, callActivityExecution);
            return true;
        }
        return false;
    }

    public static String findMatchingExceptionMapping(Exception e, List<MapExceptionEntry> exceptionMap) {
        String defaultExceptionMapping = null;
        for (MapExceptionEntry me : exceptionMap) {
            Class exceptionClassClass;
            String exceptionClass = me.getClassName();
            String errorCode = me.getErrorCode();
            if (StringUtils.isNotEmpty((CharSequence)errorCode) && StringUtils.isEmpty((CharSequence)exceptionClass) && defaultExceptionMapping == null) {
                defaultExceptionMapping = errorCode;
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)exceptionClass)) continue;
            if (e.getClass().getName().equals(exceptionClass)) {
                return errorCode;
            }
            if (!me.isAndChildren() || !(exceptionClassClass = ReflectUtil.loadClass((String)exceptionClass)).isAssignableFrom(e.getClass())) continue;
            return errorCode;
        }
        return defaultExceptionMapping;
    }

    protected static Event getCatchEventFromList(List<Event> events, ExecutionEntity parentExecution) {
        Event selectedEvent = null;
        String selectedEventErrorCode = null;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
        for (Event event : events) {
            String errorCode = ErrorPropagation.getErrorCodeFromErrorEventDefinition(event);
            if (bpmnModel != null) {
                errorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorCode);
            }
            if (selectedEvent != null && (!StringUtils.isEmpty(selectedEventErrorCode) || !StringUtils.isNotEmpty((CharSequence)errorCode))) continue;
            selectedEvent = event;
            selectedEventErrorCode = errorCode;
        }
        return selectedEvent;
    }

    protected static String getErrorCodeFromErrorEventDefinition(Event event) {
        for (EventDefinition eventDefinition : event.getEventDefinitions()) {
            if (!(eventDefinition instanceof ErrorEventDefinition)) continue;
            return ((ErrorEventDefinition)eventDefinition).getErrorCode();
        }
        return null;
    }

    protected static String retrieveErrorCode(BpmnModel bpmnModel, String errorCode) {
        String finalErrorCode = null;
        finalErrorCode = errorCode != null && bpmnModel.containsErrorRef(errorCode) ? (String)bpmnModel.getErrors().get(errorCode) : errorCode;
        return finalErrorCode;
    }
}

