/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity.data.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.CachedEntityMatcher;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntityImpl;
import org.flowable.engine.impl.persistence.entity.data.AbstractDataManager;
import org.flowable.engine.impl.persistence.entity.data.VariableInstanceDataManager;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.VariableByExecutionIdMatcher;

public class MybatisVariableInstanceDataManager
extends AbstractDataManager<VariableInstanceEntity>
implements VariableInstanceDataManager {
    protected CachedEntityMatcher<VariableInstanceEntity> variableInstanceEntity = new VariableByExecutionIdMatcher();

    public MybatisVariableInstanceDataManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends VariableInstanceEntity> getManagedEntityClass() {
        return VariableInstanceEntityImpl.class;
    }

    public VariableInstanceEntity create() {
        VariableInstanceEntityImpl variableInstanceEntity = new VariableInstanceEntityImpl();
        variableInstanceEntity.setRevision(0);
        return variableInstanceEntity;
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectVariablesByTaskId", (Object)taskId);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByTaskIds(Set<String> taskIds) {
        return this.getDbSqlSession().selectList("selectVariablesByTaskIds", taskIds);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByExecutionId(String executionId) {
        return this.getList("selectVariablesByExecutionId", executionId, this.variableInstanceEntity, true);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByExecutionIds(Set<String> executionIds) {
        return this.getDbSqlSession().selectList("selectVariablesByExecutionIds", executionIds);
    }

    @Override
    public VariableInstanceEntity findVariableInstanceByExecutionAndName(String executionId, String variableName) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("executionId", executionId);
        params.put("name", variableName);
        return (VariableInstanceEntity)this.getDbSqlSession().selectOne("selectVariableInstanceByExecutionAndName", params);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByExecutionAndNames(String executionId, Collection<String> names) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("executionId", executionId);
        params.put("names", names);
        return this.getDbSqlSession().selectList("selectVariableInstancesByExecutionAndNames", params);
    }

    @Override
    public VariableInstanceEntity findVariableInstanceByTaskAndName(String taskId, String variableName) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("taskId", taskId);
        params.put("name", variableName);
        return (VariableInstanceEntity)this.getDbSqlSession().selectOne("selectVariableInstanceByTaskAndName", params);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByTaskAndNames(String taskId, Collection<String> names) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("taskId", taskId);
        params.put("names", names);
        return this.getDbSqlSession().selectList("selectVariableInstancesByTaskAndNames", params);
    }
}

