/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity.data.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.common.impl.db.ListQueryParameterObject;
import org.flowable.engine.impl.ExecutionQueryImpl;
import org.flowable.engine.impl.ProcessInstanceQueryImpl;
import org.flowable.engine.impl.cfg.PerformanceSettings;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.CachedEntityMatcher;
import org.flowable.engine.impl.persistence.SingleCachedEntityMatcher;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.impl.persistence.entity.data.AbstractDataManager;
import org.flowable.engine.impl.persistence.entity.data.ExecutionDataManager;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.ExecutionByProcessInstanceMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.ExecutionsByParentExecutionIdAndActivityIdEntityMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.ExecutionsByParentExecutionIdEntityMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.ExecutionsByProcessInstanceIdEntityMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.ExecutionsByRootProcessInstanceMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.ExecutionsWithSameRootProcessInstanceIdMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.InactiveExecutionsByProcInstMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.InactiveExecutionsInActivityAndProcInstMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.InactiveExecutionsInActivityMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.ProcessInstancesByProcessDefinitionMatcher;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.SubProcessInstanceExecutionBySuperExecutionIdMatcher;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;

public class MybatisExecutionDataManager
extends AbstractDataManager<ExecutionEntity>
implements ExecutionDataManager {
    protected PerformanceSettings performanceSettings;
    protected CachedEntityMatcher<ExecutionEntity> executionsByParentIdMatcher = new ExecutionsByParentExecutionIdEntityMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionsByProcessInstanceIdMatcher = new ExecutionsByProcessInstanceIdEntityMatcher();
    protected SingleCachedEntityMatcher<ExecutionEntity> subProcessInstanceBySuperExecutionIdMatcher = new SubProcessInstanceExecutionBySuperExecutionIdMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionsWithSameRootProcessInstanceIdMatcher = new ExecutionsWithSameRootProcessInstanceIdMatcher();
    protected CachedEntityMatcher<ExecutionEntity> inactiveExecutionsInActivityAndProcInstMatcher = new InactiveExecutionsInActivityAndProcInstMatcher();
    protected CachedEntityMatcher<ExecutionEntity> inactiveExecutionsByProcInstMatcher = new InactiveExecutionsByProcInstMatcher();
    protected CachedEntityMatcher<ExecutionEntity> inactiveExecutionsInActivityMatcher = new InactiveExecutionsInActivityMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionByProcessInstanceMatcher = new ExecutionByProcessInstanceMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionsByRootProcessInstanceMatcher = new ExecutionsByRootProcessInstanceMatcher();
    protected CachedEntityMatcher<ExecutionEntity> executionsByParentExecutionIdAndActivityIdEntityMatcher = new ExecutionsByParentExecutionIdAndActivityIdEntityMatcher();
    protected CachedEntityMatcher<ExecutionEntity> processInstancesByProcessDefinitionMatcher = new ProcessInstancesByProcessDefinitionMatcher();

    public MybatisExecutionDataManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
        this.performanceSettings = processEngineConfiguration.getPerformanceSettings();
    }

    @Override
    public Class<? extends ExecutionEntity> getManagedEntityClass() {
        return ExecutionEntityImpl.class;
    }

    public ExecutionEntity create() {
        return ExecutionEntityImpl.createWithEmptyRelationshipCollections();
    }

    @Override
    public ExecutionEntity findById(String entityId) {
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            return this.findByIdAndFetchExecutionTree(entityId);
        }
        return (ExecutionEntity)super.findById(entityId);
    }

    protected ExecutionEntity findByIdAndFetchExecutionTree(String executionId) {
        ExecutionEntity cachedEntity = (ExecutionEntity)this.getEntityCache().findInCache(this.getManagedEntityClass(), executionId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        List<ExecutionEntity> executionEntities = this.getList("selectExecutionsWithSameRootProcessInstanceId", executionId, this.executionsWithSameRootProcessInstanceIdMatcher, true);
        for (ExecutionEntity executionEntity : executionEntities) {
            if (!executionId.equals(executionEntity.getId())) continue;
            return executionEntity;
        }
        return null;
    }

    @Override
    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(superExecutionId);
        }
        return this.getEntity("selectSubProcessInstanceBySuperExecutionId", superExecutionId, this.subProcessInstanceBySuperExecutionIdMatcher, !this.performanceSettings.isEnableEagerExecutionTreeFetching());
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(parentExecutionId);
            return this.getListFromCache(this.executionsByParentIdMatcher, parentExecutionId);
        }
        return this.getList("selectExecutionsByParentExecutionId", parentExecutionId, this.executionsByParentIdMatcher, true);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(String processInstanceId) {
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(processInstanceId);
            return this.getListFromCache(this.executionsByProcessInstanceIdMatcher, processInstanceId);
        }
        return this.getList("selectChildExecutionsByProcessInstanceId", processInstanceId, this.executionsByProcessInstanceIdMatcher, true);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByParentExecutionAndActivityIds(String parentExecutionId, Collection<String> activityIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("parentExecutionId", parentExecutionId);
        parameters.put("activityIds", activityIds);
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(parentExecutionId);
            return this.getListFromCache(this.executionsByParentExecutionIdAndActivityIdEntityMatcher, parameters);
        }
        return this.getList("selectExecutionsByParentExecutionAndActivityIds", parameters, this.executionsByParentExecutionIdAndActivityIdEntityMatcher, true);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByRootProcessInstanceId(String rootProcessInstanceId) {
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(rootProcessInstanceId);
            return this.getListFromCache(this.executionsByRootProcessInstanceMatcher, rootProcessInstanceId);
        }
        return this.getList("selectExecutionsByRootProcessInstanceId", rootProcessInstanceId, this.executionsByRootProcessInstanceMatcher, true);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByProcessInstanceId(String processInstanceId) {
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(processInstanceId);
            return this.getListFromCache(this.executionByProcessInstanceMatcher, processInstanceId);
        }
        return this.getList("selectExecutionsByProcessInstanceId", processInstanceId, this.executionByProcessInstanceMatcher, true);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByProcessInstanceId(String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("processInstanceId", processInstanceId);
        params.put("isActive", false);
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(processInstanceId);
            return this.getListFromCache(this.inactiveExecutionsByProcInstMatcher, params);
        }
        return this.getList("selectInactiveExecutionsForProcessInstance", params, this.inactiveExecutionsByProcInstMatcher, true);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByActivityIdAndProcessInstanceId(String activityId, String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("activityId", activityId);
        params.put("processInstanceId", processInstanceId);
        params.put("isActive", false);
        if (this.performanceSettings.isEnableEagerExecutionTreeFetching()) {
            this.findByIdAndFetchExecutionTree(processInstanceId);
            return this.getListFromCache(this.inactiveExecutionsInActivityAndProcInstMatcher, params);
        }
        return this.getList("selectInactiveExecutionsInActivityAndProcessInstance", params, this.inactiveExecutionsInActivityAndProcInstMatcher, true);
    }

    @Override
    public List<String> findProcessInstanceIdsByProcessDefinitionId(String processDefinitionId) {
        return this.getDbSqlSession().selectListNoCacheCheck("selectProcessInstanceIdsByProcessDefinitionId", (Object)processDefinitionId);
    }

    @Override
    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByQueryCriteria", (Object)executionQuery);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery) {
        boolean useCache;
        boolean bl = useCache = !this.performanceSettings.isEnableEagerExecutionTreeFetching();
        if (useCache) {
            return this.getDbSqlSession().selectList("selectExecutionsByQueryCriteria", (ListQueryParameterObject)executionQuery);
        }
        return this.getDbSqlSession().selectListNoCacheCheck("selectExecutionsByQueryCriteria", (ListQueryParameterObject)executionQuery);
    }

    @Override
    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectProcessInstanceCountByQueryCriteria", (Object)executionQuery);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        boolean useCache;
        boolean bl = useCache = !this.performanceSettings.isEnableEagerExecutionTreeFetching();
        if (useCache) {
            return this.getDbSqlSession().selectList("selectProcessInstanceByQueryCriteria", (ListQueryParameterObject)executionQuery);
        }
        return this.getDbSqlSession().selectListNoCacheCheck("selectProcessInstanceByQueryCriteria", (ListQueryParameterObject)executionQuery);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceAndVariablesByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        int firstResult = executionQuery.getFirstResult();
        int maxResults = executionQuery.getMaxResults();
        if (executionQuery.getProcessInstanceVariablesLimit() != null) {
            executionQuery.setMaxResults(executionQuery.getProcessInstanceVariablesLimit());
        } else {
            executionQuery.setMaxResults(this.getProcessEngineConfiguration().getExecutionQueryLimit());
        }
        executionQuery.setFirstResult(0);
        List instanceList = this.getDbSqlSession().selectListWithRawParameterNoCacheCheck("selectProcessInstanceWithVariablesByQueryCriteria", (ListQueryParameterObject)executionQuery);
        if (instanceList != null && !instanceList.isEmpty()) {
            if (firstResult > 0) {
                if (firstResult <= instanceList.size()) {
                    int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                    return instanceList.subList(firstResult, toIndex);
                }
                return Collections.EMPTY_LIST;
            }
            int toIndex = maxResults > 0 ? Math.min(maxResults, instanceList.size()) : instanceList.size();
            return instanceList.subList(0, toIndex);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap);
    }

    @Override
    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByNativeQuery", parameterMap);
    }

    @Override
    public void updateExecutionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateExecutionTenantIdForDeployment", params);
    }

    @Override
    public void updateProcessInstanceLockTime(String processInstanceId, Date lockDate, Date expirationTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", processInstanceId);
        params.put("lockTime", lockDate);
        params.put("expirationTime", expirationTime);
        int result = this.getDbSqlSession().update("updateProcessInstanceLockTime", params);
        if (result == 0) {
            throw new FlowableOptimisticLockingException("Could not lock process instance");
        }
    }

    @Override
    public void updateAllExecutionRelatedEntityCountFlags(boolean newValue) {
        this.getDbSqlSession().update("updateExecutionRelatedEntityCountEnabled", (Object)newValue);
    }

    @Override
    public void clearProcessInstanceLockTime(String processInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", processInstanceId);
        this.getDbSqlSession().update("clearProcessInstanceLockTime", params);
    }
}

