/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.persistence.entity.AbstractEntity;
import org.flowable.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.engine.impl.variable.ValueFields;
import org.flowable.engine.impl.variable.VariableType;

public class VariableInstanceEntityImpl
extends AbstractEntity
implements VariableInstanceEntity,
ValueFields,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected VariableType type;
    protected String typeName;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayRef byteArrayRef;
    protected Object cachedValue;
    protected boolean forcedUpdate;
    protected boolean deleted;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("name", this.name);
        if (this.type != null) {
            persistentState.put("typeName", this.type.getTypeName());
        }
        persistentState.put("executionId", this.executionId);
        persistentState.put("longValue", this.longValue);
        persistentState.put("doubleValue", this.doubleValue);
        persistentState.put("textValue", this.textValue);
        persistentState.put("textValue2", this.textValue2);
        if (this.byteArrayRef != null && this.byteArrayRef.getId() != null) {
            persistentState.put("byteArrayValueId", this.byteArrayRef.getId());
        }
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        return persistentState;
    }

    @Override
    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.forceUpdate();
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public byte[] getBytes() {
        this.ensureByteArrayRefInitialized();
        return this.byteArrayRef.getBytes();
    }

    @Override
    public void setBytes(byte[] bytes) {
        this.ensureByteArrayRefInitialized();
        this.byteArrayRef.setValue("var-" + this.name, bytes);
    }

    @Override
    public ByteArrayRef getByteArrayRef() {
        return this.byteArrayRef;
    }

    protected void ensureByteArrayRefInitialized() {
        if (this.byteArrayRef == null) {
            this.byteArrayRef = new ByteArrayRef();
        }
    }

    @Override
    public Object getValue() {
        if (!this.type.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.type.getValue(this);
        }
        return this.cachedValue;
    }

    @Override
    public void setValue(Object value) {
        this.type.setValue(value, this);
        this.typeName = this.type.getTypeName();
        this.cachedValue = value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        if (this.type != null) {
            return this.type.getTypeName();
        }
        return this.typeName;
    }

    @Override
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public VariableType getType() {
        return this.type;
    }

    @Override
    public void setType(VariableType type) {
        this.type = type;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VariableInstanceEntity[");
        sb.append("id=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", type=").append(this.type != null ? this.type.getTypeName() : "null");
        if (this.longValue != null) {
            sb.append(", longValue=").append(this.longValue);
        }
        if (this.doubleValue != null) {
            sb.append(", doubleValue=").append(this.doubleValue);
        }
        if (this.textValue != null) {
            sb.append(", textValue=").append(StringUtils.abbreviate((String)this.textValue, (int)40));
        }
        if (this.textValue2 != null) {
            sb.append(", textValue2=").append(StringUtils.abbreviate((String)this.textValue2, (int)40));
        }
        if (this.byteArrayRef != null && this.byteArrayRef.getId() != null) {
            sb.append(", byteArrayValueId=").append(this.byteArrayRef.getId());
        }
        sb.append("]");
        return sb.toString();
    }
}

