/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.persistence.entity.AbstractEntityNoRevision;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class IdentityLinkEntityImpl
extends AbstractEntityNoRevision
implements IdentityLinkEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String type;
    protected String userId;
    protected String groupId;
    protected String taskId;
    protected String processInstanceId;
    protected String processDefId;
    protected TaskEntity task;
    protected ExecutionEntity processInstance;
    protected ProcessDefinitionEntity processDef;

    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("id", this.id);
        persistentState.put("type", this.type);
        if (this.userId != null) {
            persistentState.put("userId", this.userId);
        }
        if (this.groupId != null) {
            persistentState.put("groupId", this.groupId);
        }
        if (this.taskId != null) {
            persistentState.put("taskId", this.taskId);
        }
        if (this.processInstanceId != null) {
            persistentState.put("processInstanceId", this.processInstanceId);
        }
        if (this.processDefId != null) {
            persistentState.put("processDefId", this.processDefId);
        }
        return persistentState;
    }

    @Override
    public boolean isUser() {
        return this.userId != null;
    }

    @Override
    public boolean isGroup() {
        return this.groupId != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        if (this.groupId != null && userId != null) {
            throw new FlowableException("Cannot assign a userId to a task assignment that already has a groupId");
        }
        this.userId = userId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        if (this.userId != null && groupId != null) {
            throw new FlowableException("Cannot assign a groupId to a task assignment that already has a userId");
        }
        this.groupId = groupId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessDefId() {
        return this.processDefId;
    }

    @Override
    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    @Override
    public TaskEntity getTask() {
        if (this.task == null && this.taskId != null) {
            this.task = (TaskEntity)CommandContextUtil.getTaskEntityManager().findById(this.taskId);
        }
        return this.task;
    }

    @Override
    public void setTask(TaskEntity task) {
        this.task = task;
        this.taskId = task.getId();
    }

    @Override
    public ExecutionEntity getProcessInstance() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(this.processInstanceId);
        }
        return this.processInstance;
    }

    @Override
    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
        this.processInstanceId = processInstance.getId();
    }

    @Override
    public ProcessDefinitionEntity getProcessDef() {
        if (this.processDef == null && this.processDefId != null) {
            this.processDef = (ProcessDefinitionEntity)CommandContextUtil.getProcessDefinitionEntityManager().findById(this.processDefId);
        }
        return this.processDef;
    }

    @Override
    public void setProcessDef(ProcessDefinitionEntity processDef) {
        this.processDef = processDef;
        this.processDefId = processDef.getId();
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IdentityLinkEntity[id=").append(this.id);
        sb.append(", type=").append(this.type);
        if (this.userId != null) {
            sb.append(", userId=").append(this.userId);
        }
        if (this.groupId != null) {
            sb.append(", groupId=").append(this.groupId);
        }
        if (this.taskId != null) {
            sb.append(", taskId=").append(this.taskId);
        }
        if (this.processInstanceId != null) {
            sb.append(", processInstanceId=").append(this.processInstanceId);
        }
        if (this.processDefId != null) {
            sb.append(", processDefId=").append(this.processDefId);
        }
        sb.append("]");
        return sb.toString();
    }
}

