/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ProcessInstanceEndHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "process-instance-end";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String processInstanceId;
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext);
        HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)historicProcessInstanceEntityManager.findById(processInstanceId = this.getStringFromJson(historicalData, "processInstanceId"));
        if (historicProcessInstance != null) {
            historicProcessInstance.setEndActivityId(this.getStringFromJson(historicalData, "activityId"));
            Date endTime = this.getDateFromJson(historicalData, "endTime");
            historicProcessInstance.setEndTime(endTime);
            historicProcessInstance.setDeleteReason(this.getStringFromJson(historicalData, "deleteReason"));
            Date startTime = historicProcessInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicProcessInstance.setDurationInMillis(endTime.getTime() - startTime.getTime());
            }
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_ENDED, historicProcessInstance));
        } else {
            historicProcessInstance = historicProcessInstanceEntityManager.create();
            historicProcessInstance.setId(this.getStringFromJson(historicalData, "id"));
            historicProcessInstance.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
            historicProcessInstance.setBusinessKey(this.getStringFromJson(historicalData, "businessKey"));
            historicProcessInstance.setProcessDefinitionId(this.getStringFromJson(historicalData, "processDefinitionId"));
            historicProcessInstance.setProcessDefinitionKey(this.getStringFromJson(historicalData, "processDefinitionKey"));
            historicProcessInstance.setProcessDefinitionName(this.getStringFromJson(historicalData, "processDefinitionName"));
            String versionString = this.getStringFromJson(historicalData, "processDefinitionVersion");
            historicProcessInstance.setProcessDefinitionVersion(versionString != null ? Integer.valueOf(versionString) : 0);
            historicProcessInstance.setDeploymentId(this.getStringFromJson(historicalData, "deploymentId"));
            historicProcessInstance.setStartTime(this.getDateFromJson(historicalData, "startTime"));
            historicProcessInstance.setStartUserId(this.getStringFromJson(historicalData, "startUserId"));
            historicProcessInstance.setStartActivityId(this.getStringFromJson(historicalData, "startActivityId"));
            historicProcessInstance.setSuperProcessInstanceId(this.getStringFromJson(historicalData, "superProcessInstanceId"));
            historicProcessInstance.setTenantId(this.getStringFromJson(historicalData, "tenantId"));
            historicProcessInstanceEntityManager.insert(historicProcessInstance, false);
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance));
            historicProcessInstance.setEndActivityId(this.getStringFromJson(historicalData, "activityId"));
            Date endTime = this.getDateFromJson(historicalData, "endTime");
            historicProcessInstance.setEndTime(endTime);
            historicProcessInstance.setDeleteReason(this.getStringFromJson(historicalData, "deleteReason"));
            Date startTime = historicProcessInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicProcessInstance.setDurationInMillis(endTime.getTime() - startTime.getTime());
            }
            historicProcessInstanceEntityManager.update(historicProcessInstance, false);
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_ENDED, historicProcessInstance));
        }
    }
}

