/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.persistence.entity.data.HistoricDetailDataManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.variable.VariableType;
import org.flowable.engine.impl.variable.VariableTypes;

public class HistoricDetailVariableUpdateHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "historic-detail-variable-update";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity activityInstance;
        String activityId = this.getStringFromJson(historicalData, "activityId");
        Boolean isMiRootExecution = this.getBooleanFromJson(historicalData, "isMiRootExecution", false);
        return isMiRootExecution != false || !StringUtils.isNotEmpty((CharSequence)activityId) || (activityInstance = this.findHistoricActivityInstance(commandContext, this.getStringFromJson(historicalData, "sourceExecutionId"), activityId)) != null;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity activityInstance;
        HistoricDetailDataManager historicDetailDataManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricDetailDataManager();
        HistoricDetailVariableInstanceUpdateEntity historicDetailEntity = historicDetailDataManager.createHistoricDetailVariableInstanceUpdate();
        historicDetailEntity.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
        historicDetailEntity.setExecutionId(this.getStringFromJson(historicalData, "executionId"));
        historicDetailEntity.setTaskId(this.getStringFromJson(historicalData, "taskId"));
        historicDetailEntity.setRevision(this.getIntegerFromJson(historicalData, "revision"));
        historicDetailEntity.setName(this.getStringFromJson(historicalData, "name"));
        String activityId = this.getStringFromJson(historicalData, "activityId");
        Boolean isMiRootExecution = this.getBooleanFromJson(historicalData, "isMiRootExecution", false);
        if (!isMiRootExecution.booleanValue() && StringUtils.isNotEmpty((CharSequence)activityId) && (activityInstance = this.findHistoricActivityInstance(commandContext, this.getStringFromJson(historicalData, "sourceExecutionId"), activityId)) != null) {
            historicDetailEntity.setActivityInstanceId(activityInstance.getId());
        }
        VariableTypes variableTypes = CommandContextUtil.getProcessEngineConfiguration().getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(this.getStringFromJson(historicalData, "variableType"));
        historicDetailEntity.setVariableType(variableType);
        historicDetailEntity.setTextValue(this.getStringFromJson(historicalData, "variableTextValue"));
        historicDetailEntity.setTextValue2(this.getStringFromJson(historicalData, "variableTextValue2"));
        historicDetailEntity.setDoubleValue(this.getDoubleFromJson(historicalData, "variableDoubleValue"));
        historicDetailEntity.setLongValue(this.getLongFromJson(historicalData, "variableLongValue"));
        String variableBytes = this.getStringFromJson(historicalData, "variableBytesValue");
        if (StringUtils.isNotEmpty((CharSequence)variableBytes)) {
            historicDetailEntity.setBytes(Base64.decodeBase64((String)variableBytes));
        }
        Date time = this.getDateFromJson(historicalData, "createTime");
        historicDetailEntity.setTime(time);
        HistoricDetailEntityManager historicDetailEntityManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricDetailEntityManager();
        historicDetailEntityManager.insert(historicDetailEntity);
    }
}

