/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.ProcessInstance;

public class SetProcessInstanceNameCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String name;

    public SetProcessInstanceNameCmd(String processInstanceId, String name) {
        this.processInstanceId = processInstanceId;
        this.name = name;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new FlowableIllegalArgumentException("processInstanceId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.processInstanceId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("process instance " + this.processInstanceId + " doesn't exist", ProcessInstance.class);
        }
        if (!execution.isProcessInstanceType()) {
            throw new FlowableObjectNotFoundException("process instance " + this.processInstanceId + " doesn't exist, the given ID references an execution, though", ProcessInstance.class);
        }
        if (execution.isSuspended()) {
            throw new FlowableException("process instance " + this.processInstanceId + " is suspended, cannot set name");
        }
        execution.setName(this.name);
        CommandContextUtil.getHistoryManager(commandContext).recordProcessInstanceNameChange(this.processInstanceId, this.name);
        return null;
    }
}

