/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskInfo;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    public Void execute(CommandContext commandContext) {
        if (this.task == null) {
            throw new FlowableIllegalArgumentException("task is null");
        }
        if (this.task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, this.task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.saveTask(this.task);
            return null;
        }
        if (this.task.getRevision() == 0) {
            CommandContextUtil.getTaskEntityManager(commandContext).insert(this.task, null, true);
            if (CommandContextUtil.getEventDispatcher().isEnabled()) {
                CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_CREATED, this.task));
            }
        } else {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            TaskInfo originalTaskEntity = (TaskInfo)CommandContextUtil.getTaskEntityManager(commandContext).findById(this.task.getId());
            if (originalTaskEntity == null && processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                originalTaskEntity = (TaskInfo)CommandContextUtil.getHistoricTaskInstanceEntityManager(commandContext).findById(this.task.getId());
            }
            String originalAssignee = originalTaskEntity.getAssignee();
            CommandContextUtil.getHistoryManager(commandContext).recordTaskInfoChange(this.task);
            if (!StringUtils.equals((CharSequence)originalAssignee, (CharSequence)this.task.getAssignee())) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getListenerNotificationHelper().executeTaskListeners(this.task, "assignment");
                if (CommandContextUtil.getEventDispatcher().isEnabled()) {
                    CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, this.task));
                }
            }
            CommandContextUtil.getTaskEntityManager(commandContext).update(this.task);
        }
        return null;
    }
}

