/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.listener;

import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.impl.scripting.ScriptingEngines;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ScriptExecutionListener
implements ExecutionListener {
    private static final long serialVersionUID = 1L;
    protected Expression script;
    protected Expression language;
    protected Expression resultVariable;

    @Override
    public void notify(DelegateExecution execution) {
        this.validateParameters();
        ScriptingEngines scriptingEngines = CommandContextUtil.getProcessEngineConfiguration().getScriptingEngines();
        Object result = scriptingEngines.evaluate(this.script.getExpressionText(), this.language.getExpressionText(), execution);
        if (this.resultVariable != null) {
            execution.setVariable(this.resultVariable.getExpressionText(), result);
        }
    }

    protected void validateParameters() {
        if (this.script == null) {
            throw new IllegalArgumentException("The field 'script' should be set on the ExecutionListener");
        }
        if (this.language == null) {
            throw new IllegalArgumentException("The field 'language' should be set on the ExecutionListener");
        }
    }

    public void setScript(Expression script) {
        this.script = script;
    }

    public void setLanguage(Expression language) {
        this.language = language;
    }

    public void setResultVariable(Expression resultVariable) {
        this.resultVariable = resultVariable;
    }
}

