/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.asyncexecutor.JobManager;
import org.flowable.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.persistence.entity.JobEntityManager;
import org.flowable.engine.impl.persistence.entity.TimerJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class IntermediateCatchTimerEventActivityBehavior
extends IntermediateCatchEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected TimerEventDefinition timerEventDefinition;

    public IntermediateCatchTimerEventActivityBehavior(TimerEventDefinition timerEventDefinition) {
        this.timerEventDefinition = timerEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        JobManager jobManager = CommandContextUtil.getJobManager();
        TimerJobEntity timerJob = jobManager.createTimerJob(this.timerEventDefinition, false, (ExecutionEntity)execution, "trigger-timer", TimerEventHandler.createConfiguration(execution.getCurrentActivityId(), null, this.timerEventDefinition.getCalendarName()));
        if (timerJob != null) {
            jobManager.scheduleTimerJob(timerJob);
        }
    }

    @Override
    public void eventCancelledByEventGateway(DelegateExecution execution) {
        JobEntityManager jobEntityManager = CommandContextUtil.getJobEntityManager();
        List jobEntities = jobEntityManager.findJobsByExecutionId(execution.getId());
        for (JobEntity jobEntity : jobEntities) {
            jobEntityManager.delete(jobEntity);
        }
        CommandContextUtil.getExecutionEntityManager().deleteExecutionAndRelatedData((ExecutionEntity)execution, "event based gateway cancel");
    }
}

