/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.spring.configurator;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.configurator.DmnEngineConfigurator;
import org.flowable.dmn.spring.SpringDmnEngineConfiguration;
import org.flowable.dmn.spring.SpringDmnExpressionManager;

public class SpringDmnEngineConfigurator
extends DmnEngineConfigurator {
    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.dmnEngineConfiguration == null) {
            this.dmnEngineConfiguration = new SpringDmnEngineConfiguration();
        } else if (!(this.dmnEngineConfiguration instanceof SpringDmnEngineConfiguration)) {
            throw new IllegalArgumentException("Expected dmnEngine configuration to be of type" + SpringDmnEngineConfiguration.class + " but was " + this.dmnEngineConfiguration.getClass());
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.dmnEngineConfiguration);
        SpringEngineConfiguration springEngineConfiguration = (SpringEngineConfiguration)engineConfiguration;
        ((SpringDmnEngineConfiguration)this.dmnEngineConfiguration).setTransactionManager(springEngineConfiguration.getTransactionManager());
        this.dmnEngineConfiguration.setExpressionManager((ExpressionManager)new SpringDmnExpressionManager(springEngineConfiguration.getApplicationContext(), springEngineConfiguration.getBeans()));
        this.initDmnEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.dmnEngineConfiguration);
    }

    protected synchronized DmnEngine initDmnEngine() {
        if (this.dmnEngineConfiguration == null) {
            throw new FlowableException("DmnEngineConfiguration is required");
        }
        return this.dmnEngineConfiguration.buildDmnEngine();
    }
}

