/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.spring.configurator;

import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.configurator.DmnEngineConfigurator;
import org.flowable.dmn.spring.SpringDmnEngineConfiguration;
import org.flowable.dmn.spring.SpringDmnExpressionManager;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.spring.SpringProcessEngineConfiguration;

public class SpringDmnEngineConfigurator
extends DmnEngineConfigurator {
    protected SpringDmnEngineConfiguration dmnEngineConfiguration;

    public void configure(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (this.dmnEngineConfiguration == null) {
            this.dmnEngineConfiguration = new SpringDmnEngineConfiguration();
        }
        this.initialiseCommonProperties(processEngineConfiguration, (AbstractEngineConfiguration)this.dmnEngineConfiguration);
        SpringProcessEngineConfiguration springProcessEngineConfiguration = (SpringProcessEngineConfiguration)processEngineConfiguration;
        this.dmnEngineConfiguration.setTransactionManager(springProcessEngineConfiguration.getTransactionManager());
        this.dmnEngineConfiguration.setExpressionManager((ExpressionManager)new SpringDmnExpressionManager(springProcessEngineConfiguration.getApplicationContext(), springProcessEngineConfiguration.getBeans()));
        this.initDmnEngine();
        this.initServiceConfigurations(processEngineConfiguration, (AbstractEngineConfiguration)this.dmnEngineConfiguration);
    }

    protected synchronized DmnEngine initDmnEngine() {
        if (this.dmnEngineConfiguration == null) {
            throw new FlowableException("DmnEngineConfiguration is required");
        }
        return this.dmnEngineConfiguration.buildDmnEngine();
    }

    public SpringDmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }

    public SpringDmnEngineConfigurator setDmnEngineConfiguration(SpringDmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        return this;
    }
}

