/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.deployer;

import java.util.Map;
import org.flowable.dmn.api.DmnDeploymentBuilder;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.engine.impl.persistence.deploy.Deployer;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnDeployer
implements Deployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnDeployer.class);

    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        if (!deployment.isNew()) {
            return;
        }
        LOGGER.debug("DmnDeployer: processing deployment {}", (Object)deployment.getName());
        DmnDeploymentBuilder dmnDeploymentBuilder = null;
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!resourceName.endsWith(".dmn")) continue;
            LOGGER.info("DmnDeployer: processing resource {}", (Object)resourceName);
            if (dmnDeploymentBuilder == null) {
                DmnRepositoryService dmnRepositoryService = CommandContextUtil.getDmnRepositoryService();
                dmnDeploymentBuilder = dmnRepositoryService.createDeployment();
            }
            dmnDeploymentBuilder.addDmnBytes(resourceName, ((ResourceEntity)resources.get(resourceName)).getBytes());
        }
        if (dmnDeploymentBuilder != null) {
            dmnDeploymentBuilder.parentDeploymentId(deployment.getId());
            if (deployment.getTenantId() != null && deployment.getTenantId().length() > 0) {
                dmnDeploymentBuilder.tenantId(deployment.getTenantId());
            }
            dmnDeploymentBuilder.deploy();
        }
    }
}

