/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.util;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntityManager;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;

public class DecisionUtil {
    public static DecisionEntity getDecisionTableEntity(String decisionTableId) {
        return DecisionUtil.getDecisionTableEntity(decisionTableId, false);
    }

    public static DecisionEntity getDecisionTableEntity(String decisionTableId, boolean checkCacheOnly) {
        if (checkCacheOnly) {
            DecisionCacheEntry cacheEntry = (DecisionCacheEntry)CommandContextUtil.getDmnEngineConfiguration().getDefinitionCache().get(decisionTableId);
            if (cacheEntry != null) {
                return cacheEntry.getDecisionEntity();
            }
            return null;
        }
        return CommandContextUtil.getDmnEngineConfiguration().getDeploymentManager().findDeployedDecisionById(decisionTableId);
    }

    public static DmnDefinition getDmnDefinitionByDecisionId(String decisionId) {
        DeploymentManager deploymentManager = CommandContextUtil.getDmnEngineConfiguration().getDeploymentManager();
        DecisionEntity decisionTableEntity = deploymentManager.findDeployedDecisionById(decisionId);
        return deploymentManager.resolveDecision(decisionTableEntity).getDmnDefinition();
    }

    public static DmnDefinition getDmnDefinitionFromCache(String definitionId) {
        DecisionCacheEntry cacheEntry = (DecisionCacheEntry)CommandContextUtil.getDmnEngineConfiguration().getDefinitionCache().get(definitionId);
        if (cacheEntry != null) {
            return cacheEntry.getDmnDefinition();
        }
        return null;
    }

    public static DecisionEntity getDecisionTableFromDatabase(String decisionTableId) {
        DecisionEntityManager decisionTableEntityManager = CommandContextUtil.getDmnEngineConfiguration().getDecisionEntityManager();
        DecisionEntity decisionTable = (DecisionEntity)decisionTableEntityManager.findById(decisionTableId);
        if (decisionTable == null) {
            throw new FlowableException("No decision table found with id " + decisionTableId);
        }
        return decisionTable;
    }

    public static DecisionService getDecisionService(String decisionId) {
        DmnDefinition dmnDefinition = DecisionUtil.getDmnDefinitionByDecisionId(decisionId);
        DecisionService decisionService = dmnDefinition.getDecisionServiceById(decisionId);
        if (decisionService == null) {
            throw new FlowableObjectNotFoundException("Could not find decision service with id: " + decisionId);
        }
        return decisionService;
    }
}

