/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.api;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;

public class RequestUtil {
    private static final FastDateFormat shortDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final FastDateFormat longDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssz");

    public static boolean getBoolean(Map<String, String> requestParams, String name, boolean defaultValue) {
        boolean value = defaultValue;
        if (requestParams.get(name) != null) {
            value = Boolean.valueOf(requestParams.get(name));
        }
        return value;
    }

    public static int getInteger(Map<String, String> requestParams, String name, int defaultValue) {
        int value = defaultValue;
        if (requestParams.get(name) != null) {
            value = Integer.valueOf(requestParams.get(name));
        }
        return value;
    }

    public static Date getDate(Map<String, String> requestParams, String name) {
        if (requestParams != null && name != null) {
            return RequestUtil.parseLongDate(requestParams.get(name));
        }
        return null;
    }

    public static Date parseLongDate(String aDate) {
        if (aDate != null) {
            String input = aDate.trim();
            if (input.endsWith("Z")) {
                input = input.substring(0, input.length() - 1) + "GMT-00:00";
            } else {
                int inset = 6;
                String s0 = input.substring(0, input.length() - inset);
                String s1 = input.substring(input.length() - inset, input.length());
                input = s0 + "GMT" + s1;
            }
            try {
                return longDateFormat.parse(input);
            }
            catch (Exception e) {
                throw new FlowableIllegalArgumentException("Failed to parse date " + input);
            }
        }
        return null;
    }

    public static String dateToString(Date date) {
        String dateString = null;
        if (date != null) {
            dateString = longDateFormat.format(date);
        }
        return dateString;
    }

    public static Integer parseToInteger(String integer) {
        Integer parsedInteger = null;
        try {
            parsedInteger = Integer.parseInt(integer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parsedInteger;
    }

    public static Date parseToDate(String date) {
        Date parsedDate = null;
        try {
            parsedDate = shortDateFormat.parse(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parsedDate;
    }
}

