/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.configurator.impl.process;

import java.util.Map;
import org.flowable.cmmn.engine.impl.process.ProcessInstanceService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;

public class DefaultProcessInstanceService
implements ProcessInstanceService {
    private static final String DELETE_REASON = "deletedFromCmmnCase";
    protected RuntimeService processEngineRuntimeService;

    public DefaultProcessInstanceService(RuntimeService runtimeService) {
        this.processEngineRuntimeService = runtimeService;
    }

    public String startProcessInstanceByKey(String processDefinitionKey, String tenantId, Map<String, Object> inParametersMap) {
        return this.startProcessInstanceByKey(processDefinitionKey, null, tenantId, inParametersMap);
    }

    public String startProcessInstanceByKey(String processDefinitionKey, String planItemInstanceId, String tenantId, Map<String, Object> inParametersMap) {
        ProcessInstanceBuilder processInstanceBuilder = this.processEngineRuntimeService.createProcessInstanceBuilder();
        processInstanceBuilder.processDefinitionKey(processDefinitionKey);
        if (tenantId != null) {
            processInstanceBuilder.tenantId(tenantId);
        }
        if (planItemInstanceId != null) {
            processInstanceBuilder.callbackId(planItemInstanceId);
            processInstanceBuilder.callbackType("cmmn-1.1-to-bpmn-2.0-child-process");
        }
        for (String target : inParametersMap.keySet()) {
            processInstanceBuilder.variable(target, inParametersMap.get(target));
        }
        ProcessInstance processInstance = processInstanceBuilder.start();
        return processInstance.getId();
    }

    public void deleteProcessInstance(String processInstanceId) {
        this.processEngineRuntimeService.deleteProcessInstance(processInstanceId, DELETE_REASON);
    }

    public Map<String, Object> getVariables(String execId) {
        return this.processEngineRuntimeService.getVariables(execId);
    }
}

