/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delete;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.IdentityLinkQueryObject;
import org.flowable.cmmn.engine.impl.history.HistoricCaseInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobService;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.service.impl.QueryVariableValue;

public class DeleteHistoricCaseInstancesUsingBatchesCmd
implements Command<String> {
    protected HistoricCaseInstanceQueryImpl historicCaseInstanceQuery;
    protected int batchSize;
    protected boolean sequential;
    protected String batchName;

    public DeleteHistoricCaseInstancesUsingBatchesCmd(HistoricCaseInstanceQueryImpl query, int batchSize, String batchName, boolean sequential) {
        this.historicCaseInstanceQuery = query;
        this.batchSize = batchSize;
        this.batchName = batchName;
        this.sequential = sequential;
    }

    public String execute(CommandContext commandContext) {
        if (this.historicCaseInstanceQuery == null) {
            throw new FlowableIllegalArgumentException("query is null");
        }
        if (this.batchSize <= 0) {
            throw new FlowableIllegalArgumentException("batchSize has to be larger than 0");
        }
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        long numberOfCaseInstancesToDelete = this.historicCaseInstanceQuery.count();
        ObjectNode batchConfiguration = engineConfiguration.getObjectMapper().createObjectNode();
        batchConfiguration.put("numberOfInstances", numberOfCaseInstancesToDelete);
        batchConfiguration.put("batchSize", this.batchSize);
        if (this.sequential) {
            batchConfiguration.put("sequential", true);
        }
        ObjectNode queryNode = batchConfiguration.putObject("query");
        this.populateQueryNode(queryNode, this.historicCaseInstanceQuery);
        for (HistoricCaseInstanceQueryImpl orQueryObject : this.historicCaseInstanceQuery.getOrQueryObjects()) {
            ObjectNode orQueryNode = queryNode.withArray("orQueryObjects").addObject();
            this.populateQueryNode(orQueryNode, orQueryObject);
        }
        String tenantId = this.historicCaseInstanceQuery.getTenantId();
        if (this.historicCaseInstanceQuery.isWithoutTenantId()) {
            tenantId = "";
        }
        Batch batch = batchService.createBatchBuilder().batchType("historicCaseDelete").tenantId(tenantId).searchKey(this.batchName).searchKey2(Authentication.getAuthenticatedUserId()).status("inProgress").batchDocumentJson(batchConfiguration.toString()).create();
        if (numberOfCaseInstancesToDelete > 0L) {
            long numberOfBatchParts = (long)Math.ceil((double)numberOfCaseInstancesToDelete / (double)this.batchSize);
            if (this.sequential) {
                this.createBatchPartsForSequentialExecution(engineConfiguration, batch, numberOfBatchParts);
            } else {
                this.createBatchPartsForParallelExecution(engineConfiguration, batch, numberOfBatchParts);
            }
        } else {
            batchService.completeBatch(batch.getId(), "completed");
        }
        return batch.getId();
    }

    protected void createBatchPartsForParallelExecution(CmmnEngineConfiguration engineConfiguration, Batch batch, long numberOfBatchParts) {
        JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
        CmmnManagementService managementService = engineConfiguration.getCmmnManagementService();
        int i = 0;
        while ((long)i < numberOfBatchParts) {
            BatchPart batchPart = managementService.createBatchPartBuilder(batch).type("computeDeleteCaseInstanceIds").searchKey(Integer.toString(i)).status("waiting").create();
            JobEntity job = jobService.createJob();
            job.setJobHandlerType("compute-delete-historic-case-ids");
            job.setJobHandlerConfiguration(batchPart.getId());
            job.setScopeType("cmmn");
            jobService.createAsyncJob(job, false);
            jobService.scheduleAsyncJob(job);
            ++i;
        }
        TimerJobService timerJobService = engineConfiguration.getJobServiceConfiguration().getTimerJobService();
        TimerJobEntity timerJob = timerJobService.createTimerJob();
        timerJob.setJobType("timer");
        timerJob.setRevision(1);
        timerJob.setJobHandlerType("compute-delete-historic-case-status");
        timerJob.setJobHandlerConfiguration(batch.getId());
        timerJob.setScopeType("cmmn");
        BusinessCalendar businessCalendar = engineConfiguration.getBusinessCalendarManager().getBusinessCalendar("cycle");
        timerJob.setDuedate(businessCalendar.resolveDuedate(engineConfiguration.getBatchStatusTimeCycleConfig()));
        timerJob.setRepeat(engineConfiguration.getBatchStatusTimeCycleConfig());
        timerJobService.scheduleTimerJob(timerJob);
    }

    protected void createBatchPartsForSequentialExecution(CmmnEngineConfiguration engineConfiguration, Batch batch, long numberOfBatchParts) {
        CmmnManagementService managementService = engineConfiguration.getCmmnManagementService();
        BatchPart firstBatchPart = managementService.createBatchPartBuilder(batch).type("deleteCase").searchKey(Integer.toString(0)).status("waiting").create();
        JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = jobService.createJob();
        job.setJobHandlerType("delete-historic-cases-sequential");
        job.setJobHandlerConfiguration(firstBatchPart.getId());
        job.setScopeType("cmmn");
        jobService.createAsyncJob(job, false);
        jobService.scheduleAsyncJob(job);
    }

    protected void populateQueryNode(ObjectNode queryNode, HistoricCaseInstanceQueryImpl query) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseDefinitionId", (String)query.getCaseDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseDefinitionKey", (String)query.getCaseDefinitionKey());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"caseDefinitionKeys", query.getCaseDefinitionKeys());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"caseDefinitionIds", query.getCaseDefinitionIds());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseDefinitionName", (String)query.getCaseDefinitionName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseDefinitionCategory", (String)query.getCaseDefinitionCategory());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseDefinitionVersion", (Integer)query.getCaseDefinitionVersion());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseInstanceId", (String)query.getCaseInstanceId());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"caseInstanceIds", query.getCaseInstanceIds());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseInstanceName", (String)query.getCaseInstanceName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseInstanceNameLike", (String)query.getCaseInstanceNameLike());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseInstanceNameLikeIgnoreCase", (String)query.getCaseInstanceNameLikeIgnoreCase());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"businessKey", (String)query.getBusinessKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"businessStatus", (String)query.getBusinessStatus());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"state", (String)query.getState());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"caseInstanceParentId", (String)query.getCaseInstanceParentId());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"withoutCaseInstanceParentId", (boolean)query.isWithoutCaseInstanceParentId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"deploymentId", (String)query.getDeploymentId());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"deploymentIds", query.getDeploymentIds());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"finished", (boolean)query.isFinished());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"unfinished", (boolean)query.isUnfinished());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"startedBefore", (Date)query.getStartedBefore());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"startedAfter", (Date)query.getStartedAfter());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"finishedBefore", (Date)query.getFinishedBefore());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"finishedAfter", (Date)query.getFinishedAfter());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"startedBy", (String)query.getStartedBy());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"lastReactivatedBefore", (Date)query.getLastReactivatedBefore());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"lastReactivatedAfter", (Date)query.getLastReactivatedAfter());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"lastReactivatedBy", (String)query.getLastReactivatedBy());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"callbackId", (String)query.getCallbackId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"callbackType", (String)query.getCallbackType());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"withoutCallbackId", (boolean)query.isWithoutCallbackId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"referenceId", (String)query.getReferenceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"referenceType", (String)query.getReferenceType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"tenantId", (String)query.getTenantId());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"withoutTenantId", (boolean)query.isWithoutTenantId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"activePlanItemDefinitionId", (String)query.getActivePlanItemDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"activePlanItemDefinitionIds", query.getActivePlanItemDefinitionIds());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"involvedUser", (String)query.getInvolvedUser());
        this.putIdentityLinkQuery(queryNode, "involvedUserIdentityLink", query.getInvolvedUserIdentityLink());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"involvedGroups", query.getInvolvedGroups());
        this.putIdentityLinkQuery(queryNode, "involvedGroupIdentityLink", query.getInvolvedGroupIdentityLink());
        for (QueryVariableValue queryVariableValue : query.getQueryVariableValues()) {
            ArrayNode queryVariablesArrayNode = queryNode.withArray("queryVariableValues");
            this.populateQueryVariableValue(queryVariablesArrayNode, queryVariableValue);
        }
    }

    protected void putIdentityLinkQuery(ObjectNode queryNode, String key, IdentityLinkQueryObject linkQueryObject) {
        if (linkQueryObject != null) {
            ObjectNode linkNode = queryNode.putObject(key);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)linkNode, (String)"userId", (String)linkQueryObject.getUserId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)linkNode, (String)"groupId", (String)linkQueryObject.getGroupId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)linkNode, (String)"type", (String)linkQueryObject.getType());
        }
    }

    protected void populateQueryVariableValue(ArrayNode queryVariablesArrayNode, QueryVariableValue variableValue) {
        if (variableValue != null) {
            ObjectNode variableNode = queryVariablesArrayNode.addObject();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"name", (String)variableValue.getName());
            variableNode.put("operator", variableValue.getOperator());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"textValue", (String)variableValue.getTextValue());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"textValue2", (String)variableValue.getTextValue2());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"longValue", (Long)variableValue.getLongValue());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"doubleValue", (Double)variableValue.getDoubleValue());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"type", (String)variableValue.getType());
            AsyncHistoryJsonUtil.putIfTrue((ObjectNode)variableNode, (String)"local", (boolean)variableValue.isLocal());
        }
    }
}

