/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.flowable.batch.api.BatchQuery;
import org.flowable.cmmn.api.CmmnHistoryCleaningManager;
import org.flowable.cmmn.api.history.HistoricCaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.HistoricCaseInstanceQueryImpl;

public class DefaultCmmnHistoryCleaningManager
implements CmmnHistoryCleaningManager {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultCmmnHistoryCleaningManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public HistoricCaseInstanceQuery createHistoricCaseInstanceCleaningQuery() {
        HistoricCaseInstanceQueryImpl historicCaseInstanceQuery = new HistoricCaseInstanceQueryImpl(this.cmmnEngineConfiguration.getCommandExecutor(), this.cmmnEngineConfiguration);
        historicCaseInstanceQuery.finishedBefore(this.getEndedBefore());
        return historicCaseInstanceQuery;
    }

    public BatchQuery createBatchCleaningQuery() {
        return this.cmmnEngineConfiguration.getCmmnManagementService().createBatchQuery().completeTimeLowerThan(this.getEndedBefore()).batchType("historicCaseDelete");
    }

    protected Date getEndedBefore() {
        Duration endedAfterDuration = this.cmmnEngineConfiguration.getCleanInstancesEndedAfter();
        Instant endedBefore = Instant.now().minus(endedAfterDuration);
        return Date.from(endedBefore);
    }
}

