/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.callback.RuntimeInstanceStateChangeCallback;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CaseInstanceHelperImpl
implements CaseInstanceHelper {
    @Override
    public CaseInstanceEntity startCaseInstance(CaseInstanceBuilder caseInstanceBuilder) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        CaseDefinition caseDefinition = null;
        if (caseInstanceBuilder.getCaseDefinitionId() != null) {
            String caseDefinitionId = caseInstanceBuilder.getCaseDefinitionId();
            CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager();
            if (caseDefinitionId != null && (caseDefinition = deploymentManager.findDeployedCaseDefinitionById(caseDefinitionId)) == null) {
                throw new FlowableObjectNotFoundException("No case definition found for id " + caseDefinitionId, CaseDefinition.class);
            }
        } else if (caseInstanceBuilder.getCaseDefinitionKey() != null) {
            String caseDefinitionKey = caseInstanceBuilder.getCaseDefinitionKey();
            CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager();
            String tenantId = caseInstanceBuilder.getTenantId();
            if (tenantId == null || "".equals(tenantId) ? (caseDefinition = deploymentManager.findDeployedLatestCaseDefinitionByKey(caseDefinitionKey)) == null : !"".equals(tenantId) && (caseDefinition = deploymentManager.findDeployedLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, caseInstanceBuilder.getTenantId())) == null) {
                throw new FlowableObjectNotFoundException("No case definition found for key " + caseDefinitionKey, CaseDefinition.class);
            }
        } else {
            throw new FlowableIllegalArgumentException("caseDefinitionKey and caseDefinitionId are null");
        }
        return this.startCaseInstance(commandContext, caseDefinition, caseInstanceBuilder);
    }

    protected CaseInstanceEntity startCaseInstance(CommandContext commandContext, CaseDefinition caseDefinition, CaseInstanceBuilder caseInstanceBuilder) {
        Map transientVariables;
        Map variables;
        CmmnDeploymentManager deploymentManager;
        CmmnModel cmmnModel;
        Case caseModel;
        CaseInstanceEntity caseInstanceEntity = this.createCaseInstanceEntity(commandContext, caseDefinition);
        if (caseInstanceBuilder.getName() != null) {
            caseInstanceEntity.setName(caseInstanceBuilder.getName());
        }
        if (caseInstanceBuilder.getBusinessKey() != null) {
            caseInstanceEntity.setBusinessKey(caseInstanceBuilder.getBusinessKey());
        }
        if (caseInstanceBuilder.getTenantId() != null) {
            caseInstanceEntity.setTenantId(caseInstanceBuilder.getTenantId());
        }
        if (caseInstanceBuilder.getCallbackId() != null) {
            caseInstanceEntity.setCallbackId(caseInstanceBuilder.getCallbackId());
        }
        if (caseInstanceBuilder.getCallbackType() != null) {
            caseInstanceEntity.setCallbackType(caseInstanceBuilder.getCallbackType());
        }
        if ((caseModel = (cmmnModel = (deploymentManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager()).resolveCaseDefinition(caseDefinition).getCmmnModel()).getCaseById(caseDefinition.getKey())).getInitiatorVariableName() != null) {
            caseInstanceEntity.setVariable(caseModel.getInitiatorVariableName(), Authentication.getAuthenticatedUserId());
        }
        if ((variables = caseInstanceBuilder.getVariables()) != null) {
            for (String variableName : variables.keySet()) {
                caseInstanceEntity.setVariable(variableName, variables.get(variableName));
            }
        }
        if ((transientVariables = caseInstanceBuilder.getTransientVariables()) != null) {
            for (String variableName : transientVariables.keySet()) {
                caseInstanceEntity.setTransientVariable(variableName, transientVariables.get(variableName));
            }
        }
        this.callCaseInstanceStateChangeCallbacks(commandContext, caseInstanceEntity, null, "active");
        CommandContextUtil.getCmmnHistoryManager().recordCaseInstanceStart(caseInstanceEntity);
        CommandContextUtil.getAgenda(commandContext).planInitPlanModelOperation(caseInstanceEntity);
        return caseInstanceEntity;
    }

    protected CaseInstanceEntity createCaseInstanceEntity(CommandContext commandContext, CaseDefinition caseDefinition) {
        CaseInstanceEntityManager caseInstanceEntityManager = CommandContextUtil.getCaseInstanceEntityManager(commandContext);
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)caseInstanceEntityManager.create();
        caseInstanceEntity.setCaseDefinitionId(caseDefinition.getId());
        caseInstanceEntity.setStartTime(CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock().getCurrentTime());
        caseInstanceEntity.setState("active");
        caseInstanceEntity.setTenantId(caseDefinition.getTenantId());
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        caseInstanceEntity.setStartUserId(authenticatedUserId);
        caseInstanceEntityManager.insert(caseInstanceEntity);
        caseInstanceEntity.setSatisfiedSentryPartInstances(new ArrayList(1));
        return caseInstanceEntity;
    }

    @Override
    public void callCaseInstanceStateChangeCallbacks(CommandContext commandContext, CaseInstance caseInstance, String oldState, String newState) {
        Map<String, List<RuntimeInstanceStateChangeCallback>> caseInstanceCallbacks;
        if (caseInstance.getCallbackId() != null && caseInstance.getCallbackType() != null && (caseInstanceCallbacks = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getCaseInstanceStateChangeCallbacks()) != null && caseInstanceCallbacks.containsKey(caseInstance.getCallbackType())) {
            for (RuntimeInstanceStateChangeCallback caseInstanceCallback : caseInstanceCallbacks.get(caseInstance.getCallbackType())) {
                CallbackData callBackData = new CallbackData(caseInstance.getCallbackId(), caseInstance.getCallbackType(), caseInstance.getId(), oldState, newState);
                caseInstanceCallback.stateChanged(callBackData);
            }
        }
    }
}

