/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.impl.runtime.CmmnRuntimeServiceImpl;

public class CaseInstanceBuilderImpl
implements CaseInstanceBuilder {
    protected CmmnRuntimeServiceImpl cmmnRuntimeService;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected String name;
    protected String businessKey;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected String tenantId;
    protected String outcome;
    protected String callbackType;
    protected String callbackId;

    public CaseInstanceBuilderImpl() {
    }

    public CaseInstanceBuilderImpl(CmmnRuntimeServiceImpl cmmnRuntimeService) {
        this.cmmnRuntimeService = cmmnRuntimeService;
    }

    public CaseInstanceBuilder caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public CaseInstanceBuilder caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    public CaseInstanceBuilder name(String name) {
        this.name = name;
        return this;
    }

    public CaseInstanceBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public CaseInstanceBuilder variables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        if (variables != null) {
            this.variables.putAll(variables);
        }
        return this;
    }

    public CaseInstanceBuilder variable(String variableName, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, value);
        return this;
    }

    public CaseInstanceBuilder transientVariables(Map<String, Object> transientVariables) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        this.transientVariables.putAll(transientVariables);
        return this;
    }

    public CaseInstanceBuilder transientVariable(String variableName, Object value) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        this.transientVariables.put(variableName, value);
        return this;
    }

    public CaseInstanceBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public CaseInstanceBuilder outcome(String outcome) {
        this.outcome = outcome;
        return this;
    }

    public CaseInstanceBuilder callbackType(String callbackType) {
        this.callbackType = callbackType;
        return this;
    }

    public CaseInstanceBuilder callbackId(String callbackId) {
        this.callbackId = callbackId;
        return this;
    }

    public CaseInstance start() {
        return this.cmmnRuntimeService.startCaseInstance(this);
    }

    public CaseInstance startWithForm() {
        return this.cmmnRuntimeService.startCaseInstanceWithForm(this);
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getName() {
        return this.name;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, Object> getTransientVariables() {
        return this.transientVariables;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public String getCallbackId() {
        return this.callbackId;
    }
}

