/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.AssociationXmlConverter;
import org.flowable.cmmn.converter.BaseCmmnXmlConverter;
import org.flowable.cmmn.converter.CaseRefExpressionXmlConverter;
import org.flowable.cmmn.converter.CaseTaskXmlConverter;
import org.flowable.cmmn.converter.CaseXmlConverter;
import org.flowable.cmmn.converter.CmmnDiBoundsXmlConverter;
import org.flowable.cmmn.converter.CmmnDiEdgeXmlConverter;
import org.flowable.cmmn.converter.CmmnDiExtensionXmlConverter;
import org.flowable.cmmn.converter.CmmnDiShapeXmlConverter;
import org.flowable.cmmn.converter.CmmnDiWaypointXmlConverter;
import org.flowable.cmmn.converter.CmmnXMLException;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.ConditionXmlConverter;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.DecisionRefExpressionXmlConverter;
import org.flowable.cmmn.converter.DecisionTaskXmlConverter;
import org.flowable.cmmn.converter.DecisionXmlConverter;
import org.flowable.cmmn.converter.DefaultControlXmlConverter;
import org.flowable.cmmn.converter.DefinitionsXmlConverter;
import org.flowable.cmmn.converter.DocumentationXmlConverter;
import org.flowable.cmmn.converter.EntryCriterionXmlConverter;
import org.flowable.cmmn.converter.ExitCriterionXmlConverter;
import org.flowable.cmmn.converter.ExtensionElementsXMLConverter;
import org.flowable.cmmn.converter.GenericEventListenerXmlConverter;
import org.flowable.cmmn.converter.HumanTaskXmlConverter;
import org.flowable.cmmn.converter.IndentingXMLStreamWriter;
import org.flowable.cmmn.converter.ItemControlXmlConverter;
import org.flowable.cmmn.converter.ManualActivationRuleXmlConverter;
import org.flowable.cmmn.converter.MilestoneXmlConverter;
import org.flowable.cmmn.converter.PlanFragmentXmlConverter;
import org.flowable.cmmn.converter.PlanItemOnPartXmlConverter;
import org.flowable.cmmn.converter.PlanItemStartTriggerXmlConverter;
import org.flowable.cmmn.converter.PlanItemXmlConverter;
import org.flowable.cmmn.converter.PlanModelXmlConverter;
import org.flowable.cmmn.converter.ProcessRefExpressionXmlConverter;
import org.flowable.cmmn.converter.ProcessTaskXmlConverter;
import org.flowable.cmmn.converter.ProcessXmlConverter;
import org.flowable.cmmn.converter.RepetitionRuleXmlConverter;
import org.flowable.cmmn.converter.RequiredRuleXmlConverter;
import org.flowable.cmmn.converter.SentryIfPartXmlConverter;
import org.flowable.cmmn.converter.SentryXmlConverter;
import org.flowable.cmmn.converter.StageXmlConverter;
import org.flowable.cmmn.converter.StandardEventXmlConverter;
import org.flowable.cmmn.converter.TaskXmlConverter;
import org.flowable.cmmn.converter.TextAnnotationXmlConverter;
import org.flowable.cmmn.converter.TextXmlConverter;
import org.flowable.cmmn.converter.TimerEventListenerXmlConverter;
import org.flowable.cmmn.converter.TimerExpressionXmlConverter;
import org.flowable.cmmn.converter.UserEventListenerXmlConverter;
import org.flowable.cmmn.converter.exception.XMLException;
import org.flowable.cmmn.converter.export.AssociationExport;
import org.flowable.cmmn.converter.export.CaseExport;
import org.flowable.cmmn.converter.export.CmmnDIExport;
import org.flowable.cmmn.converter.export.DefinitionsRootExport;
import org.flowable.cmmn.converter.export.StageExport;
import org.flowable.cmmn.converter.export.TextAnnotationExport;
import org.flowable.cmmn.converter.util.CriterionUtil;
import org.flowable.cmmn.converter.util.PlanItemDependencyUtil;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CasePageTask;
import org.flowable.cmmn.model.CmmnDiEdge;
import org.flowable.cmmn.model.CmmnDiShape;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.Decision;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.HasEntryCriteria;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.ParentCompletionRule;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Process;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.Task;
import org.flowable.cmmn.model.TextAnnotation;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CmmnXmlConverter
implements CmmnXmlConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CmmnXmlConverter.class);
    protected static final String XSD_LOCATION = "org/flowable/impl/cmmn/parser/CMMN11.xsd";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static Map<String, BaseCmmnXmlConverter> elementConverters = new HashMap<String, BaseCmmnXmlConverter>();
    protected ClassLoader classloader;

    public static void addElementConverter(BaseCmmnXmlConverter converter) {
        elementConverters.put(converter.getXMLElementName(), converter);
    }

    public CmmnModel convertToCmmnModel(InputStreamProvider inputStreamProvider) {
        return this.convertToCmmnModel(inputStreamProvider, true, true);
    }

    public CmmnModel convertToCmmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeBpmnXml) {
        return this.convertToCmmnModel(inputStreamProvider, validateSchema, enableSafeBpmnXml, DEFAULT_ENCODING);
    }

    public CmmnModel convertToCmmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeBpmnXml, String encoding) {
        CmmnModel cmmnModel;
        InputStreamReader in;
        XMLInputFactory xif = XMLInputFactory.newInstance();
        if (xif.isPropertySupported("javax.xml.stream.isReplacingEntityReferences")) {
            xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.supportDTD")) {
            xif.setProperty("javax.xml.stream.supportDTD", false);
        }
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        if (validateSchema) {
            try {
                in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
                try {
                    if (!enableSafeBpmnXml) {
                        this.validateModel(inputStreamProvider);
                    } else {
                        this.validateModel(xif.createXMLStreamReader(in));
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CmmnXMLException("The CMMN 1.1 xml is not properly encoded", e);
            }
            catch (XMLStreamException e) {
                throw new CmmnXMLException("Error while reading the CMMN 1.1 XML", e);
            }
            catch (Exception e) {
                throw new CmmnXMLException(e.getMessage(), e);
            }
        }
        in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
        try {
            cmmnModel = this.convertToCmmnModel(xif.createXMLStreamReader(in));
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new CmmnXMLException("The CMMN 1.1 xml is not properly encoded", e);
            }
            catch (XMLStreamException e) {
                throw new CmmnXMLException("Error while reading the CMMN 1.1 XML", e);
            }
            catch (IOException e) {
                throw new CmmnXMLException(e.getMessage(), e);
            }
        }
        in.close();
        return cmmnModel;
    }

    public CmmnModel convertToCmmnModel(XMLStreamReader xtr) {
        ConversionHelper conversionHelper = new ConversionHelper();
        conversionHelper.setCmmnModel(new CmmnModel());
        try {
            String currentXmlElement = null;
            while (xtr.hasNext()) {
                try {
                    xtr.next();
                }
                catch (Exception e) {
                    LOGGER.debug("Error reading CMMN XML document", (Throwable)e);
                    throw new CmmnXMLException("Error reading XML", e);
                }
                if (xtr.isStartElement()) {
                    currentXmlElement = xtr.getLocalName();
                    if (!elementConverters.containsKey(currentXmlElement)) continue;
                    elementConverters.get(currentXmlElement).convertToCmmnModel(xtr, conversionHelper);
                    continue;
                }
                if (!xtr.isEndElement()) continue;
                currentXmlElement = null;
                if (!elementConverters.containsKey(xtr.getLocalName())) continue;
                elementConverters.get(xtr.getLocalName()).elementEnd(xtr, conversionHelper);
            }
        }
        catch (CmmnXMLException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error processing CMMN XML document", (Throwable)e);
            throw new CmmnXMLException("Error processing CMMN XML document", e);
        }
        this.processCmmnElements(conversionHelper);
        return conversionHelper.getCmmnModel();
    }

    public void validateModel(InputStreamProvider inputStreamProvider) throws Exception {
        Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(inputStreamProvider.getInputStream()));
    }

    public void validateModel(XMLStreamReader xmlStreamReader) throws Exception {
        Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(xmlStreamReader));
    }

    protected Schema createSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        if (this.classloader != null) {
            schema = factory.newSchema(this.classloader.getResource(XSD_LOCATION));
        }
        if (schema == null) {
            schema = factory.newSchema(this.getClass().getClassLoader().getResource(XSD_LOCATION));
        }
        if (schema == null) {
            throw new CmmnXMLException("CMND XSD could not be found");
        }
        return schema;
    }

    public byte[] convertToXML(CmmnModel model) {
        return this.convertToXML(model, DEFAULT_ENCODING);
    }

    public byte[] convertToXML(CmmnModel model, String encoding) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, encoding);
            XMLStreamWriter writer = xof.createXMLStreamWriter(out);
            IndentingXMLStreamWriter xtw = new IndentingXMLStreamWriter(writer);
            DefinitionsRootExport.writeRootElement(model, xtw, encoding);
            for (Case caseModel : model.getCases()) {
                CaseExport.writeCase(model, caseModel, xtw);
                Stage planModel = caseModel.getPlanModel();
                StageExport.getInstance().writePlanItemDefinition(model, planModel, xtw);
                xtw.writeEndElement();
            }
            List associations = model.getAssociations();
            List textAnnotations = model.getTextAnnotations();
            for (TextAnnotation textAnnotation : textAnnotations) {
                TextAnnotationExport.writeTextAnnotations(textAnnotation, xtw);
                String textAnnotationId = textAnnotation.getId();
                if (textAnnotationId == null) continue;
                for (Association association : associations) {
                    if (!textAnnotationId.equals(association.getSourceRef()) && !textAnnotationId.equals(association.getTargetRef())) continue;
                    AssociationExport.writeAssociation(association, xtw);
                }
            }
            CmmnDIExport.writeCmmnDI(model, xtw);
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            outputStream.close();
            xtw.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error("Error writing CMMN XML", (Throwable)e);
            throw new XMLException("Error writing CMMN XML", e);
        }
    }

    protected void processCmmnElements(ConversionHelper conversionHelper) {
        CmmnModel cmmnModel = conversionHelper.getCmmnModel();
        for (Case caze : cmmnModel.getCases()) {
            this.processPlanFragment(cmmnModel, (PlanFragment)caze.getPlanModel());
        }
        this.ensureIds(conversionHelper.getPlanFragments(), "planFragment_");
        this.ensureIds(conversionHelper.getStages(), "stage_");
        this.ensureIds(conversionHelper.getEntryCriteria(), "entryCriterion_");
        this.ensureIds(conversionHelper.getExitCriteria(), "exitCriterion_");
        this.ensureIds(conversionHelper.getSentries(), "sentry_");
        this.ensureIds(conversionHelper.getSentryOnParts(), "onPart_");
        this.ensureIds(conversionHelper.getSentryIfParts(), "ifPart_");
        this.ensureIds(conversionHelper.getPlanItems(), "planItem_");
        this.ensureIds(conversionHelper.getPlanItemDefinitions(), "planItemDefinition_");
        for (Case caze : cmmnModel.getCases()) {
            this.processSentries(caze.getPlanModel(), (PlanFragment)caze.getPlanModel());
            for (CaseElement caseElement : conversionHelper.getCaseElements().get(caze)) {
                caze.getAllCaseElements().put(caseElement.getId(), caseElement);
            }
        }
        for (SentryOnPart sentryOnPart : conversionHelper.getSentryOnParts()) {
            Optional<PlanItem> planItem = conversionHelper.findPlanItem(sentryOnPart.getSourceRef());
            if (!planItem.isPresent()) continue;
            sentryOnPart.setSource(planItem.get());
        }
        for (PlanItem planItem : conversionHelper.getPlanItems()) {
            planItem.getEntryDependencies().addAll(PlanItemDependencyUtil.getEntryDependencies(planItem));
            planItem.getExitDependencies().addAll(PlanItemDependencyUtil.getExitDependencies(planItem));
            planItem.getEntryDependencies().forEach(entryDependency -> entryDependency.addEntryDependentPlanItem(planItem));
            planItem.getExitDependencies().forEach(exitDependency -> exitDependency.addExitDependentPlanItem(planItem));
        }
        this.processCriteria(cmmnModel, conversionHelper.getEntryCriteria());
        this.processCriteria(cmmnModel, conversionHelper.getExitCriteria());
        for (CmmnDiShape diShape : conversionHelper.getDiShapes()) {
            cmmnModel.addGraphicInfo(diShape.getCmmnElementRef(), diShape.getGraphicInfo());
        }
        this.processDiEdges(cmmnModel, conversionHelper.getDiEdges());
        this.ensureIds(cmmnModel.getAssociations(), "association_");
        this.processAssociations(cmmnModel);
    }

    protected void processDiEdges(CmmnModel cmmnModel, List<CmmnDiEdge> diEdges) {
        if (diEdges.isEmpty()) {
            return;
        }
        Map<String, List<Association>> associationsMap = cmmnModel.getAssociations().stream().collect(Collectors.groupingBy(association -> association.getSourceRef() + "_" + association.getTargetRef()));
        for (CmmnDiEdge diEdge : diEdges) {
            String associationKey = diEdge.getCmmnElementRef() + "_" + diEdge.getTargetCmmnElementRef();
            List<Object> edgeAssociations = associationsMap.containsKey(associationKey) ? associationsMap.get(associationKey) : associationsMap.getOrDefault(diEdge.getTargetCmmnElementRef() + "_" + diEdge.getCmmnElementRef(), Collections.emptyList());
            ListIterator<Association> associationIterator = edgeAssociations.listIterator();
            if (associationIterator.hasNext()) {
                Association association2 = associationIterator.next();
                association2.setId(diEdge.getId());
                associationIterator.remove();
            }
            cmmnModel.addEdgeInfo(diEdge.getId(), diEdge);
            cmmnModel.addFlowGraphicInfoList(diEdge.getId(), diEdge.getWaypoints());
        }
    }

    protected void processCriteria(CmmnModel cmmnModel, List<Criterion> criteria) {
        for (Criterion criterion : criteria) {
            Sentry sentry = criterion.getSentry();
            List onParts = sentry != null ? sentry.getOnParts() : Collections.emptyList();
            for (SentryOnPart onPart : onParts) {
                PlanItem source = onPart.getSource();
                if (source == null) continue;
                Association association = new Association();
                association.setTargetElement((BaseElement)criterion);
                association.setTargetRef(criterion.getId());
                association.setSourceElement((BaseElement)source);
                association.setSourceRef(source.getId());
                association.setTransitionEvent(onPart.getStandardEvent());
                cmmnModel.addAssociation(association);
            }
        }
    }

    protected void processPlanFragment(CmmnModel cmmnModel, PlanFragment planFragment) {
        this.processPlanItems(cmmnModel, planFragment);
        if (planFragment instanceof Stage) {
            Stage stage = (Stage)planFragment;
            for (PlanItemDefinition planItemDefinition : stage.getPlanItemDefinitions()) {
                if (!(planItemDefinition instanceof PlanFragment)) continue;
                this.processPlanFragment(cmmnModel, (PlanFragment)planItemDefinition);
            }
            if (!stage.getExitCriteria().isEmpty()) {
                this.resolveExitCriteriaSentry((HasExitCriteria)stage);
            }
        }
    }

    protected void processPlanItems(CmmnModel cmmnModel, PlanFragment planFragment) {
        for (PlanItem planItem : planFragment.getPlanItems()) {
            Stage parentStage = planItem.getParentStage();
            PlanItemDefinition planItemDefinition = parentStage.findPlanItemDefinitionInStageOrUpwards(planItem.getDefinitionRef());
            if (planItemDefinition == null) {
                throw new FlowableException("No matching plan item definition found for reference " + planItem.getDefinitionRef() + " of plan item " + planItem.getId());
            }
            planItem.setPlanItemDefinition(planItemDefinition);
            this.procesPlanItem(cmmnModel, planItem, planItemDefinition);
        }
    }

    protected void procesPlanItem(CmmnModel cmmnModel, PlanItem planItem, PlanItemDefinition planItemDefinition) {
        if (!planItem.getEntryCriteria().isEmpty()) {
            this.resolveEntryCriteria((HasEntryCriteria)planItem);
        }
        if (!planItem.getExitCriteria().isEmpty()) {
            Task task;
            boolean exitCriteriaAllowed = true;
            if (planItemDefinition instanceof Task && !(task = (Task)planItemDefinition).isBlocking() && StringUtils.isEmpty((CharSequence)task.getBlockingExpression())) {
                exitCriteriaAllowed = false;
            }
            if (exitCriteriaAllowed) {
                this.resolveExitCriteriaSentry((HasExitCriteria)planItem);
            } else {
                LOGGER.warn("Ignoring exit criteria on plan item {}", (Object)planItem.getId());
                planItem.getExitCriteria().clear();
            }
        }
        if (planItemDefinition instanceof Stage) {
            Stage planItemStage = (Stage)planItemDefinition;
            planItemStage.setPlanItem(planItem);
            this.processPlanFragment(cmmnModel, (PlanFragment)planItemStage);
        } else if (planItemDefinition instanceof ProcessTask) {
            Process process;
            ProcessTask processTask = (ProcessTask)planItemDefinition;
            if (processTask.getProcessRef() != null && (process = cmmnModel.getProcessById(processTask.getProcessRef())) != null) {
                processTask.setProcess(process);
            }
        } else if (planItemDefinition instanceof DecisionTask) {
            Decision decision;
            DecisionTask decisionTask = (DecisionTask)planItemDefinition;
            if (decisionTask.getDecisionRef() != null && (decision = cmmnModel.getDecisionById(decisionTask.getDecisionRef())) != null) {
                decisionTask.setDecision(decision);
            }
        } else if (planItemDefinition instanceof TimerEventListener) {
            PlanItemControl itemControl;
            TimerEventListener timerEventListener = (TimerEventListener)planItemDefinition;
            String sourceRef = timerEventListener.getTimerStartTriggerSourceRef();
            PlanItem startTriggerPlanItem = timerEventListener.getParentStage().findPlanItemInPlanFragmentOrUpwards(sourceRef);
            if (startTriggerPlanItem != null) {
                timerEventListener.setTimerStartTriggerPlanItem(startTriggerPlanItem);
                Criterion criterion = new Criterion();
                criterion.setId(CriterionUtil.generateEntryCriterionId((HasEntryCriteria)planItem));
                criterion.setEntryCriterion(true);
                SentryOnPart sentryOnPart = new SentryOnPart();
                sentryOnPart.setSourceRef(startTriggerPlanItem.getId());
                sentryOnPart.setSource(startTriggerPlanItem);
                sentryOnPart.setStandardEvent(timerEventListener.getTimerStartTriggerStandardEvent());
                Sentry sentry = new Sentry();
                sentry.addSentryOnPart(sentryOnPart);
                criterion.setSentry(sentry);
                planItem.addEntryCriterion(criterion);
            }
            if ((itemControl = planItem.getItemControl()) != null) {
                itemControl.setRepetitionRule(null);
            }
        } else if (planItemDefinition instanceof CasePageTask) {
            if (planItem.getItemControl() == null) {
                PlanItemControl planItemControl = new PlanItemControl();
                planItem.setItemControl(planItemControl);
            }
            if (planItem.getItemControl().getParentCompletionRule() == null) {
                ParentCompletionRule parentCompletionRule = new ParentCompletionRule();
                parentCompletionRule.setType("ignore");
                planItem.getItemControl().setParentCompletionRule(parentCompletionRule);
            }
        }
    }

    protected void resolveEntryCriteria(HasEntryCriteria hasEntryCriteria) {
        for (Criterion entryCriterion : hasEntryCriteria.getEntryCriteria()) {
            if (entryCriterion.getSentry() != null) continue;
            Sentry sentry = entryCriterion.getParent().findSentry(entryCriterion.getSentryRef());
            if (sentry != null) {
                entryCriterion.setSentry(sentry);
                continue;
            }
            throw new FlowableException("No sentry found for reference " + entryCriterion.getSentryRef() + " of entry criterion " + entryCriterion.getId());
        }
    }

    protected void resolveExitCriteriaSentry(HasExitCriteria hasExitCriteria) {
        for (Criterion exitCriterion : hasExitCriteria.getExitCriteria()) {
            Sentry sentry = exitCriterion.getParent().findSentry(exitCriterion.getSentryRef());
            if (sentry != null) {
                exitCriterion.setSentry(sentry);
                continue;
            }
            throw new FlowableException("No sentry found for reference " + exitCriterion.getSentryRef() + " of exit criterion " + exitCriterion.getId());
        }
    }

    protected void processSentries(Stage planModelStage, PlanFragment planFragment) {
        for (Sentry sentry : planFragment.getSentries()) {
            for (SentryOnPart onPart : sentry.getOnParts()) {
                PlanItem planItem = planModelStage.findPlanItemInPlanFragmentOrDownwards(onPart.getSourceRef());
                if (planItem != null) {
                    onPart.setSource(planItem);
                    continue;
                }
                throw new FlowableException("Could not resolve on part source reference " + onPart.getSourceRef() + " of sentry " + sentry.getId());
            }
        }
        for (PlanItem planItem : planFragment.getPlanItems()) {
            if (!(planItem.getPlanItemDefinition() instanceof PlanFragment)) continue;
            this.processSentries(planModelStage, (PlanFragment)planItem.getPlanItemDefinition());
        }
    }

    protected void ensureIds(List<? extends BaseElement> elements, String idPrefix) {
        HashMap<Object, BaseElement> elementsWithId = new HashMap<Object, BaseElement>();
        HashSet<BaseElement> baseElementsWithoutId = new HashSet<BaseElement>();
        for (BaseElement baseElement : elements) {
            if (baseElement.getId() != null) {
                elementsWithId.put(baseElement.getId(), baseElement);
                continue;
            }
            baseElementsWithoutId.add(baseElement);
        }
        if (!baseElementsWithoutId.isEmpty()) {
            int counter = 1;
            for (BaseElement baseElement : baseElementsWithoutId) {
                String id = idPrefix + counter++;
                while (elementsWithId.containsKey(id)) {
                    id = idPrefix + counter++;
                }
                baseElement.setId(id);
                elementsWithId.put(id, baseElement);
            }
        }
    }

    protected void processAssociations(CmmnModel cmmnModel) {
        List associations = cmmnModel.getAssociations();
        for (Association association : associations) {
            String targetRef;
            String sourceRef = association.getSourceRef();
            if (sourceRef != null && association.getSourceElement() == null) {
                PlanItem planItem = cmmnModel.findPlanItem(sourceRef);
                if (planItem != null) {
                    association.setSourceElement((BaseElement)planItem);
                } else {
                    TextAnnotation textAnnotation = cmmnModel.findTextAnnotation(sourceRef);
                    if (textAnnotation != null) {
                        association.setSourceElement((BaseElement)textAnnotation);
                    }
                }
            }
            if ((targetRef = association.getTargetRef()) == null || association.getTargetElement() != null) continue;
            PlanItem planItem = cmmnModel.findPlanItem(targetRef);
            if (planItem != null) {
                association.setTargetElement((BaseElement)planItem);
                continue;
            }
            TextAnnotation textAnnotation = cmmnModel.findTextAnnotation(targetRef);
            if (textAnnotation == null) continue;
            association.setTargetElement((BaseElement)textAnnotation);
        }
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public static Map<String, BaseCmmnXmlConverter> getConvertersToCmmnModelMap() {
        return elementConverters;
    }

    public static void setConvertersToCmmnModelMap(Map<String, BaseCmmnXmlConverter> convertersToCmmnModelMap) {
        elementConverters = convertersToCmmnModelMap;
    }

    static {
        CmmnXmlConverter.addElementConverter(new DefinitionsXmlConverter());
        CmmnXmlConverter.addElementConverter(new DocumentationXmlConverter());
        CmmnXmlConverter.addElementConverter(new CaseXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanModelXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanFragmentXmlConverter());
        CmmnXmlConverter.addElementConverter(new StageXmlConverter());
        CmmnXmlConverter.addElementConverter(new MilestoneXmlConverter());
        CmmnXmlConverter.addElementConverter(new TaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new HumanTaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanItemXmlConverter());
        CmmnXmlConverter.addElementConverter(new ItemControlXmlConverter());
        CmmnXmlConverter.addElementConverter(new DefaultControlXmlConverter());
        CmmnXmlConverter.addElementConverter(new RequiredRuleXmlConverter());
        CmmnXmlConverter.addElementConverter(new RepetitionRuleXmlConverter());
        CmmnXmlConverter.addElementConverter(new ManualActivationRuleXmlConverter());
        CmmnXmlConverter.addElementConverter(new SentryXmlConverter());
        CmmnXmlConverter.addElementConverter(new EntryCriterionXmlConverter());
        CmmnXmlConverter.addElementConverter(new ExitCriterionXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanItemOnPartXmlConverter());
        CmmnXmlConverter.addElementConverter(new SentryIfPartXmlConverter());
        CmmnXmlConverter.addElementConverter(new CaseTaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new ProcessXmlConverter());
        CmmnXmlConverter.addElementConverter(new ProcessTaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new DecisionXmlConverter());
        CmmnXmlConverter.addElementConverter(new DecisionTaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new GenericEventListenerXmlConverter());
        CmmnXmlConverter.addElementConverter(new TimerEventListenerXmlConverter());
        CmmnXmlConverter.addElementConverter(new UserEventListenerXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanItemStartTriggerXmlConverter());
        CmmnXmlConverter.addElementConverter(new TextAnnotationXmlConverter());
        CmmnXmlConverter.addElementConverter(new AssociationXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiShapeXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiEdgeXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiBoundsXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiWaypointXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiExtensionXmlConverter());
        CmmnXmlConverter.addElementConverter(new StandardEventXmlConverter());
        CmmnXmlConverter.addElementConverter(new ProcessRefExpressionXmlConverter());
        CmmnXmlConverter.addElementConverter(new CaseRefExpressionXmlConverter());
        CmmnXmlConverter.addElementConverter(new DecisionRefExpressionXmlConverter());
        CmmnXmlConverter.addElementConverter(new ConditionXmlConverter());
        CmmnXmlConverter.addElementConverter(new TimerExpressionXmlConverter());
        CmmnXmlConverter.addElementConverter(new TextXmlConverter());
        CmmnXmlConverter.addElementConverter(new ExtensionElementsXMLConverter());
    }
}

