/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.util;

import java.util.ArrayList;
import java.util.List;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;

public class PlanItemUtil {
    public static List<PlanItem> getAllParentPlanItems(PlanItem planItem) {
        ArrayList<PlanItem> parentPlanItems = new ArrayList<PlanItem>();
        PlanItemUtil.internalGetParentPlanItems(planItem, parentPlanItems);
        return parentPlanItems;
    }

    protected static void internalGetParentPlanItems(PlanItem planItem, List<PlanItem> parentPlanItems) {
        PlanItem parentPlanItem;
        Stage parentStage = planItem.getParentStage();
        if (parentStage != null && !parentStage.isPlanModel() && (parentPlanItem = parentStage.findPlanItemForPlanItemDefinitionInPlanFragmentOrUpwards(parentStage.getId())) != null) {
            parentPlanItems.add(parentPlanItem);
            PlanItemUtil.internalGetParentPlanItems(parentPlanItem, parentPlanItems);
        }
    }

    public static List<PlanItem> getAllChildPlanItems(PlanFragment planFragment) {
        ArrayList<PlanItem> planItems = new ArrayList<PlanItem>();
        PlanItemUtil.internalGetAllChildPlanItems(planFragment, planItems);
        return planItems;
    }

    protected static void internalGetAllChildPlanItems(PlanFragment planFragment, List<PlanItem> planItems) {
        for (PlanItem planItem : planFragment.getPlanItems()) {
            planItems.add(planItem);
            PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
            if (!(planItemDefinition instanceof PlanFragment)) continue;
            PlanItemUtil.internalGetAllChildPlanItems((PlanFragment)planItemDefinition, planItems);
        }
    }
}

