/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.model.CmmnModel;

public class DefinitionsRootExport
implements CmmnXmlConstants {
    protected static final Set<String> defaultNamespaces = new HashSet<String>(Arrays.asList("xsi", "flowable", "cmmndi", "dc", "di"));

    public static void writeRootElement(CmmnModel model, XMLStreamWriter xtw, String encoding) throws Exception {
        xtw.writeStartDocument(encoding, "1.0");
        xtw.writeStartElement("definitions");
        xtw.setDefaultNamespace("http://www.omg.org/spec/CMMN/20151109/MODEL");
        xtw.writeDefaultNamespace("http://www.omg.org/spec/CMMN/20151109/MODEL");
        xtw.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xtw.writeNamespace("flowable", "http://flowable.org/cmmn");
        xtw.writeNamespace("cmmndi", "http://www.omg.org/spec/CMMN/20151109/CMMNDI");
        xtw.writeNamespace("dc", "http://www.omg.org/spec/CMMN/20151109/DC");
        xtw.writeNamespace("di", "http://www.omg.org/spec/CMMN/20151109/DI");
        for (String prefix : model.getNamespaces().keySet()) {
            if (defaultNamespaces.contains(prefix) || !StringUtils.isNotEmpty((CharSequence)prefix)) continue;
            xtw.writeNamespace(prefix, (String)model.getNamespaces().get(prefix));
        }
        if (StringUtils.isNotEmpty((CharSequence)model.getTargetNamespace())) {
            xtw.writeAttribute("targetNamespace", model.getTargetNamespace());
        } else {
            xtw.writeAttribute("targetNamespace", "http://www.flowable.org/test");
        }
        if (StringUtils.isNotEmpty((CharSequence)model.getExporter())) {
            xtw.writeAttribute("exporter", model.getExporter());
        }
        if (StringUtils.isNotEmpty((CharSequence)model.getExporterVersion())) {
            xtw.writeAttribute("exporterVersion", model.getExporterVersion());
        }
    }
}

