/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.PlanItem;

public class CriteriaExport
implements CmmnXmlConstants {
    public static void writeCriteriaElements(PlanItem planItem, XMLStreamWriter xtw) throws Exception {
        CriteriaExport.writeEntryCriteriaElements(planItem.getEntryCriteria(), xtw);
        CriteriaExport.writeExitCriteriaElements(planItem.getExitCriteria(), xtw);
    }

    public static void writeEntryCriteriaElements(List<Criterion> criterionList, XMLStreamWriter xtw) throws Exception {
        CriteriaExport.writeCriteriaElements("entryCriterion", criterionList, xtw);
    }

    public static void writeExitCriteriaElements(List<Criterion> criterionList, XMLStreamWriter xtw) throws Exception {
        CriteriaExport.writeCriteriaElements("exitCriterion", criterionList, xtw);
    }

    public static void writeCriteriaElements(String criteriaElementLabel, List<Criterion> criterionList, XMLStreamWriter xtw) throws Exception {
        for (Criterion criterion : criterionList) {
            xtw.writeStartElement(criteriaElementLabel);
            xtw.writeAttribute("id", criterion.getId());
            if (StringUtils.isNotEmpty((CharSequence)criterion.getName())) {
                xtw.writeAttribute("name", criterion.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)criterion.getSentryRef())) {
                xtw.writeAttribute("sentryRef", criterion.getSentryRef());
            }
            if (StringUtils.isNotEmpty((CharSequence)criterion.getExitType())) {
                xtw.writeAttribute("http://flowable.org/cmmn", "exitType", criterion.getExitType());
            }
            if (StringUtils.isNotEmpty((CharSequence)criterion.getExitEventType())) {
                xtw.writeAttribute("http://flowable.org/cmmn", "exitEventType", criterion.getExitEventType());
            }
            xtw.writeEndElement();
        }
    }
}

