/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.model.CompletionNeutralRule;
import org.flowable.cmmn.model.ManualActivationRule;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.RequiredRule;

public class PlanItemControlExport
implements CmmnXmlConstants {
    public static void writeItemControl(PlanItemControl planItemControl, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("itemControl");
        PlanItemControlExport.writeItemControlContent(planItemControl, xtw);
        xtw.writeEndElement();
    }

    public static void writeDefaultControl(PlanItemControl planItemControl, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("defaultControl");
        PlanItemControlExport.writeItemControlContent(planItemControl, xtw);
        xtw.writeEndElement();
    }

    protected static void writeItemControlContent(PlanItemControl planItemControl, XMLStreamWriter xtw) throws Exception {
        PlanItemControlExport.writeRequiredRule(planItemControl.getRequiredRule(), xtw);
        PlanItemControlExport.writeRepetitionRule(planItemControl.getRepetitionRule(), xtw);
        PlanItemControlExport.writeManualActivationRule(planItemControl.getManualActivationRule(), xtw);
        PlanItemControlExport.writeCompletionNeutralRule(planItemControl.getCompletionNeutralRule(), xtw);
    }

    public static void writeRequiredRule(RequiredRule requiredRule, XMLStreamWriter xtw) throws XMLStreamException {
        if (requiredRule != null) {
            xtw.writeStartElement("requiredRule");
            if (StringUtils.isNotEmpty((CharSequence)requiredRule.getCondition())) {
                xtw.writeStartElement("condition");
                xtw.writeCData(requiredRule.getCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }

    public static void writeRepetitionRule(RepetitionRule repetitionRule, XMLStreamWriter xtw) throws XMLStreamException {
        if (repetitionRule != null) {
            xtw.writeStartElement("repetitionRule");
            if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getRepetitionCounterVariableName())) {
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "counterVariable", repetitionRule.getRepetitionCounterVariableName());
            }
            if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getCondition())) {
                xtw.writeStartElement("condition");
                xtw.writeCData(repetitionRule.getCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }

    public static void writeManualActivationRule(ManualActivationRule manualActivationRule, XMLStreamWriter xtw) throws XMLStreamException {
        if (manualActivationRule != null) {
            xtw.writeStartElement("manualActivationRule");
            if (StringUtils.isNotEmpty((CharSequence)manualActivationRule.getCondition())) {
                xtw.writeStartElement("condition");
                xtw.writeCData(manualActivationRule.getCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }

    public static void writeCompletionNeutralRule(CompletionNeutralRule completionNeutralRule, XMLStreamWriter xtw) throws XMLStreamException {
        if (completionNeutralRule != null) {
            xtw.writeStartElement("extensionElements");
            xtw.writeStartElement("flowable", "completionNeutralRule", "http://flowable.org/cmmn");
            if (StringUtils.isNotBlank((CharSequence)completionNeutralRule.getCondition())) {
                xtw.writeStartElement("condition");
                xtw.writeCData(completionNeutralRule.getCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
    }
}

