/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.XMLStreamReaderUtil;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.converter.util.CommaSplitter;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CustomProperty;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Resource;
import org.flowable.bpmn.model.UserTask;
import org.flowable.bpmn.model.alfresco.AlfrescoUserTask;

public class UserTaskXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();
    protected static final List<ExtensionAttribute> defaultUserTaskAttributes = Arrays.asList(new ExtensionAttribute("formKey"), new ExtensionAttribute("sameDeployment"), new ExtensionAttribute("dueDate"), new ExtensionAttribute("businessCalendarName"), new ExtensionAttribute("assignee"), new ExtensionAttribute("owner"), new ExtensionAttribute("priority"), new ExtensionAttribute("candidateUsers"), new ExtensionAttribute("candidateGroups"), new ExtensionAttribute("category"), new ExtensionAttribute("formFieldValidation"), new ExtensionAttribute("extensionId"), new ExtensionAttribute("skipExpression"), new ExtensionAttribute("taskIdVariableName"));

    public UserTaskXMLConverter() {
        HumanPerformerParser humanPerformerParser = new HumanPerformerParser();
        this.childParserMap.put(humanPerformerParser.getElementName(), humanPerformerParser);
        PotentialOwnerParser potentialOwnerParser = new PotentialOwnerParser();
        this.childParserMap.put(potentialOwnerParser.getElementName(), potentialOwnerParser);
        CustomIdentityLinkParser customIdentityLinkParser = new CustomIdentityLinkParser();
        this.childParserMap.put(customIdentityLinkParser.getElementName(), customIdentityLinkParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return UserTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "userTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String expression;
        String formKey = BpmnXMLUtil.getAttributeValue("formKey", xtr);
        UserTask userTask = null;
        if (StringUtils.isNotEmpty((CharSequence)formKey) && model.getUserTaskFormTypes() != null && model.getUserTaskFormTypes().contains(formKey)) {
            userTask = new AlfrescoUserTask();
        }
        if (userTask == null) {
            userTask = new UserTask();
        }
        BpmnXMLUtil.addXMLLocation(userTask, xtr);
        userTask.setDueDate(BpmnXMLUtil.getAttributeValue("dueDate", xtr));
        userTask.setBusinessCalendarName(BpmnXMLUtil.getAttributeValue("businessCalendarName", xtr));
        userTask.setCategory(BpmnXMLUtil.getAttributeValue("category", xtr));
        userTask.setFormKey(formKey);
        userTask.setValidateFormFields(BpmnXMLUtil.getAttributeValue("formFieldValidation", xtr));
        userTask.setAssignee(BpmnXMLUtil.getAttributeValue("assignee", xtr));
        userTask.setOwner(BpmnXMLUtil.getAttributeValue("owner", xtr));
        userTask.setPriority(BpmnXMLUtil.getAttributeValue("priority", xtr));
        userTask.setTaskIdVariableName(BpmnXMLUtil.getAttributeValue("taskIdVariableName", xtr));
        String sameDeploymentAttribute = BpmnXMLUtil.getAttributeValue("sameDeployment", xtr);
        if ("false".equalsIgnoreCase(sameDeploymentAttribute)) {
            userTask.setSameDeployment(false);
        }
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("candidateUsers", xtr))) {
            expression = BpmnXMLUtil.getAttributeValue("candidateUsers", xtr);
            userTask.getCandidateUsers().addAll(this.parseDelimitedList(expression));
        }
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("candidateGroups", xtr))) {
            expression = BpmnXMLUtil.getAttributeValue("candidateGroups", xtr);
            userTask.getCandidateGroups().addAll(this.parseDelimitedList(expression));
        }
        userTask.setExtensionId(BpmnXMLUtil.getAttributeValue("extensionId", xtr));
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("skipExpression", xtr))) {
            expression = BpmnXMLUtil.getAttributeValue("skipExpression", xtr);
            userTask.setSkipExpression(expression);
        }
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)userTask, defaultElementAttributes, defaultActivityAttributes, defaultUserTaskAttributes);
        this.parseChildElements(this.getXMLElementName(), (BaseElement)userTask, this.childParserMap, model, xtr);
        return userTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        UserTask userTask = (UserTask)element;
        this.writeQualifiedAttribute("assignee", userTask.getAssignee(), xtw);
        this.writeQualifiedAttribute("owner", userTask.getOwner(), xtw);
        this.writeQualifiedAttribute("candidateUsers", this.convertToDelimitedString(userTask.getCandidateUsers()), xtw);
        this.writeQualifiedAttribute("candidateGroups", this.convertToDelimitedString(userTask.getCandidateGroups()), xtw);
        this.writeQualifiedAttribute("dueDate", userTask.getDueDate(), xtw);
        this.writeQualifiedAttribute("businessCalendarName", userTask.getBusinessCalendarName(), xtw);
        this.writeQualifiedAttribute("category", userTask.getCategory(), xtw);
        this.writeQualifiedAttribute("formKey", userTask.getFormKey(), xtw);
        if (!userTask.isSameDeployment()) {
            this.writeQualifiedAttribute("sameDeployment", "false", xtw);
        }
        this.writeQualifiedAttribute("formFieldValidation", userTask.getValidateFormFields(), xtw);
        if (userTask.getPriority() != null) {
            this.writeQualifiedAttribute("priority", userTask.getPriority(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getExtensionId())) {
            this.writeQualifiedAttribute("extensionId", userTask.getExtensionId(), xtw);
        }
        if (userTask.getSkipExpression() != null) {
            this.writeQualifiedAttribute("skipExpression", userTask.getSkipExpression(), xtw);
        }
        if (userTask.getTaskIdVariableName() != null) {
            this.writeQualifiedAttribute("taskIdVariableName", userTask.getTaskIdVariableName(), xtw);
        }
        BpmnXMLUtil.writeCustomAttributes(userTask.getAttributes().values(), xtw, defaultElementAttributes, defaultActivityAttributes, defaultUserTaskAttributes);
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        UserTask userTask = (UserTask)element;
        didWriteExtensionStartElement = this.writeFormProperties((FlowElement)userTask, didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = this.writeCustomIdentities(element, didWriteExtensionStartElement, xtw);
        if (!userTask.getCustomProperties().isEmpty()) {
            for (CustomProperty customProperty : userTask.getCustomProperties()) {
                if (StringUtils.isEmpty((CharSequence)customProperty.getSimpleValue())) continue;
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("flowable", customProperty.getName(), "http://flowable.org/bpmn");
                xtw.writeCharacters(customProperty.getSimpleValue());
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }

    protected boolean writeCustomIdentities(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        UserTask userTask = (UserTask)element;
        if (userTask.getCustomUserIdentityLinks().isEmpty() && userTask.getCustomGroupIdentityLinks().isEmpty()) {
            return didWriteExtensionStartElement;
        }
        if (!didWriteExtensionStartElement) {
            xtw.writeStartElement("extensionElements");
            didWriteExtensionStartElement = true;
        }
        HashSet identityLinkTypes = new HashSet();
        identityLinkTypes.addAll(userTask.getCustomUserIdentityLinks().keySet());
        identityLinkTypes.addAll(userTask.getCustomGroupIdentityLinks().keySet());
        for (String identityType : identityLinkTypes) {
            this.writeCustomIdentities(userTask, identityType, (Set)userTask.getCustomUserIdentityLinks().get(identityType), (Set)userTask.getCustomGroupIdentityLinks().get(identityType), xtw);
        }
        return didWriteExtensionStartElement;
    }

    protected void writeCustomIdentities(UserTask userTask, String identityType, Set<String> users, Set<String> groups, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("flowable", "customResource", "http://flowable.org/bpmn");
        this.writeDefaultAttribute("name", identityType, xtw);
        ArrayList<String> identityList = new ArrayList<String>();
        if (users != null) {
            for (String userId : users) {
                identityList.add("user(" + userId + ")");
            }
        }
        if (groups != null) {
            for (String groupId : groups) {
                identityList.add("group(" + groupId + ")");
            }
        }
        String delimitedString = this.convertToDelimitedString(identityList);
        xtw.writeStartElement("resourceAssignmentExpression");
        xtw.writeStartElement("formalExpression");
        xtw.writeCharacters(delimitedString);
        xtw.writeEndElement();
        xtw.writeEndElement();
        xtw.writeEndElement();
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }

    public static class HumanPerformerParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "humanPerformer";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String expression;
            String resourceElement = XMLStreamReaderUtil.moveDown(xtr);
            if (StringUtils.isNotEmpty((CharSequence)resourceElement) && "resourceAssignmentExpression".equals(resourceElement) && StringUtils.isNotEmpty((CharSequence)(expression = XMLStreamReaderUtil.moveDown(xtr))) && "formalExpression".equals(expression)) {
                ((UserTask)parentElement).setAssignee(xtr.getElementText());
            }
        }
    }

    public static class PotentialOwnerParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "potentialOwner";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String resourceElement = XMLStreamReaderUtil.moveDown(xtr);
            if (StringUtils.isNotEmpty((CharSequence)resourceElement) && "resourceAssignmentExpression".equals(resourceElement)) {
                String expression = XMLStreamReaderUtil.moveDown(xtr);
                if (StringUtils.isNotEmpty((CharSequence)expression) && "formalExpression".equals(expression)) {
                    List<String> assignmentList = CommaSplitter.splitCommas(xtr.getElementText());
                    for (String assignmentValue : assignmentList) {
                        if (assignmentValue == null || (assignmentValue = assignmentValue.trim()).length() == 0) continue;
                        String userPrefix = "user(";
                        String groupPrefix = "group(";
                        if (assignmentValue.startsWith(userPrefix)) {
                            assignmentValue = assignmentValue.substring(userPrefix.length(), assignmentValue.length() - 1).trim();
                            ((UserTask)parentElement).getCandidateUsers().add(assignmentValue);
                            continue;
                        }
                        if (assignmentValue.startsWith(groupPrefix)) {
                            assignmentValue = assignmentValue.substring(groupPrefix.length(), assignmentValue.length() - 1).trim();
                            ((UserTask)parentElement).getCandidateGroups().add(assignmentValue);
                            continue;
                        }
                        ((UserTask)parentElement).getCandidateGroups().add(assignmentValue);
                    }
                }
            } else if (StringUtils.isNotEmpty((CharSequence)resourceElement) && "resourceRef".equals(resourceElement)) {
                String resourceId = xtr.getElementText();
                if (model.containsResourceId(resourceId)) {
                    Resource resource = model.getResource(resourceId);
                    ((UserTask)parentElement).getCandidateGroups().add(resource.getName());
                } else {
                    Resource resource = new Resource(resourceId, resourceId);
                    model.addResource(resource);
                    ((UserTask)parentElement).getCandidateGroups().add(resource.getName());
                }
            }
        }
    }

    public static class CustomIdentityLinkParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "customResource";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String expression;
            String identityLinkType = BpmnXMLUtil.getAttributeValue("name", xtr);
            if (identityLinkType == null) {
                identityLinkType = xtr.getAttributeValue(null, "name");
            }
            if (identityLinkType == null) {
                return;
            }
            String resourceElement = XMLStreamReaderUtil.moveDown(xtr);
            if (StringUtils.isNotEmpty((CharSequence)resourceElement) && "resourceAssignmentExpression".equals(resourceElement) && StringUtils.isNotEmpty((CharSequence)(expression = XMLStreamReaderUtil.moveDown(xtr))) && "formalExpression".equals(expression)) {
                List<String> assignmentList = CommaSplitter.splitCommas(xtr.getElementText());
                for (String assignmentValue : assignmentList) {
                    if (assignmentValue == null || (assignmentValue = assignmentValue.trim()).length() == 0) continue;
                    String userPrefix = "user(";
                    String groupPrefix = "group(";
                    if (assignmentValue.startsWith(userPrefix)) {
                        assignmentValue = assignmentValue.substring(userPrefix.length(), assignmentValue.length() - 1).trim();
                        ((UserTask)parentElement).addCustomUserIdentityLink(assignmentValue, identityLinkType);
                        continue;
                    }
                    if (assignmentValue.startsWith(groupPrefix)) {
                        assignmentValue = assignmentValue.substring(groupPrefix.length(), assignmentValue.length() - 1).trim();
                        ((UserTask)parentElement).addCustomGroupIdentityLink(assignmentValue, identityLinkType);
                        continue;
                    }
                    ((UserTask)parentElement).addCustomGroupIdentityLink(assignmentValue, identityLinkType);
                }
            }
        }
    }
}

