/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.SendEventServiceTask;

public class EventOutParameterParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "eventOutParameter";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        String source = xtr.getAttributeValue(null, "source");
        String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
        String target = xtr.getAttributeValue(null, "target");
        String targetExpression = xtr.getAttributeValue(null, "targetExpression");
        if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && (StringUtils.isNotEmpty((CharSequence)target) || StringUtils.isNotEmpty((CharSequence)targetExpression))) {
            IOParameter parameter = new IOParameter();
            if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                parameter.setSourceExpression(sourceExpression);
            } else {
                parameter.setSource(source);
            }
            if (StringUtils.isNotEmpty((CharSequence)targetExpression)) {
                parameter.setTargetExpression(targetExpression);
            } else {
                parameter.setTarget(target);
            }
            for (int i = 0; i < xtr.getAttributeCount(); ++i) {
                String attributeName = xtr.getAttributeLocalName(i);
                if ("source".equals(attributeName) || "sourceExpression".equals(attributeName) || "target".equals(attributeName) || "targetExpression".equals(attributeName)) continue;
                ExtensionAttribute extensionAttribute = new ExtensionAttribute();
                extensionAttribute.setName(attributeName);
                extensionAttribute.setValue(xtr.getAttributeValue(i));
                if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeNamespace(i))) {
                    extensionAttribute.setNamespace(xtr.getAttributeNamespace(i));
                }
                if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributePrefix(i))) {
                    extensionAttribute.setNamespacePrefix(xtr.getAttributePrefix(i));
                }
                parameter.addAttribute(extensionAttribute);
            }
            ((SendEventServiceTask)parentElement).getEventOutParameters().add(parameter);
        }
    }
}

