/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl.persistence.entity;

import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchBuilder;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.BatchQueryImpl;
import org.flowable.batch.service.impl.persistence.entity.BatchByteArrayRef;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchEntityImpl;
import org.flowable.batch.service.impl.persistence.entity.BatchEntityManager;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntityManager;
import org.flowable.batch.service.impl.persistence.entity.data.BatchDataManager;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractServiceEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class BatchEntityManagerImpl
extends AbstractServiceEngineEntityManager<BatchServiceConfiguration, BatchEntity, BatchDataManager>
implements BatchEntityManager {
    public BatchEntityManagerImpl(BatchServiceConfiguration batchServiceConfiguration, BatchDataManager batchDataManager) {
        super((AbstractServiceConfiguration)batchServiceConfiguration, (DataManager)batchDataManager);
    }

    @Override
    public List<Batch> findBatchesBySearchKey(String searchKey) {
        return ((BatchDataManager)this.dataManager).findBatchesBySearchKey(searchKey);
    }

    @Override
    public List<Batch> findAllBatches() {
        return ((BatchDataManager)this.dataManager).findAllBatches();
    }

    @Override
    public List<Batch> findBatchesByQueryCriteria(BatchQueryImpl batchQuery) {
        return ((BatchDataManager)this.dataManager).findBatchesByQueryCriteria(batchQuery);
    }

    @Override
    public long findBatchCountByQueryCriteria(BatchQueryImpl batchQuery) {
        return ((BatchDataManager)this.dataManager).findBatchCountByQueryCriteria(batchQuery);
    }

    @Override
    public BatchEntity createBatch(BatchBuilder batchBuilder) {
        BatchEntityImpl batchEntity = (BatchEntityImpl)((BatchDataManager)this.dataManager).create();
        batchEntity.setBatchType(batchBuilder.getBatchType());
        batchEntity.setBatchSearchKey(batchBuilder.getSearchKey());
        batchEntity.setBatchSearchKey2(batchBuilder.getSearchKey2());
        batchEntity.setCreateTime(this.getClock().getCurrentTime());
        batchEntity.setStatus(batchBuilder.getStatus());
        batchEntity.setBatchDocumentJson(batchBuilder.getBatchDocumentJson());
        batchEntity.setTenantId(batchBuilder.getTenantId());
        ((BatchDataManager)this.dataManager).insert(batchEntity);
        return batchEntity;
    }

    public void delete(String batchId) {
        BatchByteArrayRef batchDocRefId;
        BatchEntity batch = (BatchEntity)((BatchDataManager)this.dataManager).findById(batchId);
        List<BatchPart> batchParts = this.getBatchPartEntityManager().findBatchPartsByBatchId(batch.getId());
        if (batchParts != null && batchParts.size() > 0) {
            for (BatchPart batchPart : batchParts) {
                this.getBatchPartEntityManager().deleteBatchPartEntityAndResources((BatchPartEntity)batchPart);
            }
        }
        if ((batchDocRefId = batch.getBatchDocRefId()) != null && batchDocRefId.getId() != null) {
            batchDocRefId.delete();
        }
        this.delete(batch);
    }

    protected BatchPartEntityManager getBatchPartEntityManager() {
        return ((BatchServiceConfiguration)this.serviceConfiguration).getBatchPartEntityManager();
    }
}

