/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import java.util.Map;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class SetVariablesCmd
implements Command<Void> {
    protected String appDefinitionId;
    protected Map<String, Object> variables;

    public SetVariablesCmd(String appDefinitionId, Map<String, Object> variables) {
        this.appDefinitionId = appDefinitionId;
        this.variables = variables;
    }

    public Void execute(CommandContext commandContext) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        if (this.variables == null) {
            throw new FlowableIllegalArgumentException("variables is null");
        }
        if (this.variables.isEmpty()) {
            throw new FlowableIllegalArgumentException("variables is empty");
        }
        VariableTypes variableTypes = CommandContextUtil.getAppEngineConfiguration().getVariableTypes();
        VariableService variableService = CommandContextUtil.getVariableService(commandContext);
        for (String variableName : this.variables.keySet()) {
            Object variableValue = this.variables.get(variableName);
            VariableType type = variableTypes.findVariableType(variableValue);
            VariableInstanceEntity variableInstance = variableService.createVariableInstance(variableName, type, variableValue);
            variableInstance.setScopeId(this.appDefinitionId);
            variableInstance.setScopeType("app");
            variableService.updateVariableInstance(variableInstance);
        }
        return null;
    }
}

