/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.persistence.entity.data.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntity;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntity;
import org.flowable.app.engine.impl.persistence.entity.AppResourceEntity;
import org.flowable.app.engine.impl.persistence.entity.data.TableDataManager;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class TableDataManagerImpl
implements TableDataManager {
    public static Map<Class<? extends Entity>, String> entityToTableNameMap = new HashMap<Class<? extends Entity>, String>();

    @Override
    public Map<String, Long> getTableCount() {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (String table : this.getTablesPresentInDatabase()) {
            counts.put(table, (Long)CommandContextUtil.getDbSqlSession().selectOne("org.flowable.app.engine.impl.TableData.selectTableCount", (Object)table));
        }
        return counts;
    }

    @Override
    public Collection<String> getTablesPresentInDatabase() {
        return entityToTableNameMap.values();
    }

    @Override
    public String getTableName(Class<?> entityClass, boolean withPrefix) {
        String databaseTablePrefix = CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
        String tableName = entityToTableNameMap.get(entityClass);
        if (withPrefix) {
            return databaseTablePrefix + tableName;
        }
        return tableName;
    }

    static {
        entityToTableNameMap.put(AppDeploymentEntity.class, "ACT_APP_DEPLOYMENT");
        entityToTableNameMap.put(AppResourceEntity.class, "ACT_APP_DEPLOYMENT_RESOURCE");
        entityToTableNameMap.put(AppDefinitionEntity.class, "ACT_APP_APPDEF");
        entityToTableNameMap.put(VariableInstanceEntity.class, "ACT_RU_VARIABLE");
        entityToTableNameMap.put(IdentityLinkEntity.class, "ACT_RU_IDENTITYLINK");
    }
}

