/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Category;
import facebook4j.FacebookException;
import facebook4j.Place;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlaceJSONImpl
extends FacebookResponseImpl
implements Place,
Serializable {
    private static final long serialVersionUID = 859565077681007052L;
    private String id;
    private String name;
    private List<Category> categories;
    private Place.Location location;

    PlaceJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    PlaceJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            if (z_F4JInternalParseUtil.isJSONArray("category_list", json)) {
                JSONArray categoriesJSONArray = json.getJSONArray("category_list");
                this.categories = new ArrayList<Category>();
                for (int i = 0; i < categoriesJSONArray.length(); ++i) {
                    this.categories.add(new CategoryJSONImpl(categoriesJSONArray.getJSONObject(i)));
                }
            }
            if (z_F4JInternalParseUtil.isJSONObject("location", json)) {
                JSONObject locationJSONObject = json.getJSONObject("location");
                this.location = new LocationJSONImpl(locationJSONObject);
            } else {
                this.location = new LocationJSONImpl(z_F4JInternalParseUtil.getRawString("location", json));
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Category> getCategories() {
        return this.categories;
    }

    @Override
    public Place.Location getLocation() {
        return this.location;
    }

    static ResponseList<Place> createPlaceList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Place> places = new ResponseListImpl<Place>(size, json, new Place[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject placeJSONObject = list.getJSONObject(i);
                PlaceJSONImpl place = new PlaceJSONImpl(placeJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(place, placeJSONObject);
                }
                places.add(place);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(places, list);
            }
            return places;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlaceJSONImpl other = (PlaceJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "PlaceJSONImpl{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", categories=" + this.categories + ", location=" + this.location + '}';
    }

    static final class LocationJSONImpl
    implements Place.Location,
    Serializable {
        private static final long serialVersionUID = 1578695411333203753L;
        private String street;
        private String city;
        private String state;
        private String country;
        private String zip;
        private Double latitude;
        private Double longitude;
        private String text;

        LocationJSONImpl(JSONObject json) throws FacebookException {
            this.street = z_F4JInternalParseUtil.getRawString("street", json);
            this.city = z_F4JInternalParseUtil.getRawString("city", json);
            this.state = z_F4JInternalParseUtil.getRawString("state", json);
            this.country = z_F4JInternalParseUtil.getRawString("country", json);
            this.zip = z_F4JInternalParseUtil.getRawString("zip", json);
            this.latitude = z_F4JInternalParseUtil.getDouble("latitude", json);
            this.longitude = z_F4JInternalParseUtil.getDouble("longitude", json);
        }

        LocationJSONImpl(String text) throws FacebookException {
            this.text = text;
        }

        public String getStreet() {
            return this.street;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountry() {
            return this.country;
        }

        public String getZip() {
            return this.zip;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocationJSONImpl)) {
                return false;
            }
            LocationJSONImpl that = (LocationJSONImpl)o;
            if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
                return false;
            }
            if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
                return false;
            }
            if (this.latitude != null ? !this.latitude.equals(that.latitude) : that.latitude != null) {
                return false;
            }
            if (this.longitude != null ? !this.longitude.equals(that.longitude) : that.longitude != null) {
                return false;
            }
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
                return false;
            }
            if (this.street != null ? !this.street.equals(that.street) : that.street != null) {
                return false;
            }
            if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
                return false;
            }
            return !(this.zip != null ? !this.zip.equals(that.zip) : that.zip != null);
        }

        public int hashCode() {
            int result = this.street != null ? this.street.hashCode() : 0;
            result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
            result = 31 * result + (this.zip != null ? this.zip.hashCode() : 0);
            result = 31 * result + (this.latitude != null ? this.latitude.hashCode() : 0);
            result = 31 * result + (this.longitude != null ? this.longitude.hashCode() : 0);
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "LocationJSONImpl{street='" + this.street + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", country='" + this.country + '\'' + ", zip='" + this.zip + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", text='" + this.text + '\'' + '}';
        }
    }
}

