/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.auth;

import facebook4j.auth.AccessToken;
import facebook4j.auth.Authorization;
import facebook4j.auth.NullAuthorization;
import facebook4j.auth.OAuthAuthorization;
import facebook4j.conf.Configuration;

public final class AuthorizationFactory {
    public static Authorization getInstance(Configuration conf) {
        Authorization auth = null;
        String appId = conf.getOAuthAppId();
        String appSecret = conf.getOAuthAppSecret();
        if (appId != null && appSecret != null) {
            OAuthAuthorization oauth = new OAuthAuthorization(conf);
            String accessToken = conf.getOAuthAccessToken();
            if (accessToken != null) {
                oauth.setOAuthAccessToken(new AccessToken(accessToken, null));
            }
            auth = oauth;
        } else {
            auth = NullAuthorization.getInstance();
        }
        return auth;
    }
}

