/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.exparity.hamcrest.date.core.TemporalWrapper;

public class LocalDateWrapper
implements TemporalWrapper<LocalDate> {
    private final LocalDate wrapped;

    public LocalDateWrapper(Date date) {
        this.wrapped = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public LocalDateWrapper(LocalDate date) {
        this.wrapped = date;
    }

    @Override
    public long difference(LocalDate other, ChronoUnit unit) {
        return Math.abs(this.wrapped.until(other, unit));
    }

    @Override
    public boolean isAfter(LocalDate other) {
        return this.wrapped.isAfter(other);
    }

    @Override
    public boolean isBefore(LocalDate other) {
        return this.wrapped.isBefore(other);
    }

    @Override
    public boolean isSame(LocalDate other) {
        return this.wrapped.isEqual(other);
    }

    @Override
    public boolean isSameDay(LocalDate other) {
        return this.wrapped.isEqual(other);
    }

    @Override
    public LocalDate unwrap() {
        return this.wrapped;
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

