/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import org.exparity.hamcrest.date.core.TemporalWrapper;

public class LocalDateTimeWrapper
implements TemporalWrapper<LocalDateTime> {
    private final LocalDateTime wrapped;
    private final TemporalUnit accuracy;

    public LocalDateTimeWrapper(Date date) {
        this.wrapped = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        this.accuracy = ChronoUnit.MILLIS;
    }

    public LocalDateTimeWrapper(LocalDateTime date) {
        this.wrapped = date;
        this.accuracy = ChronoUnit.NANOS;
    }

    public LocalDateTimeWrapper(int year, Month month, int dayOfMonth) {
        this.wrapped = LocalDateTime.of(LocalDate.of(year, month, dayOfMonth), LocalTime.NOON);
        this.accuracy = ChronoUnit.DAYS;
    }

    public LocalDateTimeWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        this.wrapped = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
        this.accuracy = ChronoUnit.SECONDS;
    }

    public LocalDateTimeWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos) {
        this.wrapped = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanos);
        this.accuracy = ChronoUnit.NANOS;
    }

    @Override
    public long difference(LocalDateTime other, ChronoUnit unit) {
        return Math.abs(this.wrapped.truncatedTo(this.accuracy).until(other, unit));
    }

    @Override
    public boolean isAfter(LocalDateTime other) {
        return this.wrapped.truncatedTo(this.accuracy).isAfter(other.truncatedTo(this.accuracy));
    }

    @Override
    public boolean isBefore(LocalDateTime other) {
        return this.wrapped.truncatedTo(this.accuracy).isBefore(other.truncatedTo(this.accuracy));
    }

    @Override
    public boolean isSame(LocalDateTime other) {
        return this.wrapped.truncatedTo(this.accuracy).isEqual(other.truncatedTo(this.accuracy));
    }

    @Override
    public boolean isSameDay(LocalDateTime other) {
        return this.wrapped.truncatedTo(ChronoUnit.DAYS).isEqual(other.truncatedTo(ChronoUnit.DAYS));
    }

    @Override
    public LocalDateTime unwrap() {
        return this.wrapped;
    }
}

